/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.AttachmentStatus;
import com.amazonaws.services.networkfirewall.model.transform.AttachmentMarshaller;
import java.io.Serializable;

public class Attachment
implements Serializable,
Cloneable,
StructuredPojo {
    private String subnetId;
    private String endpointId;
    private String status;
    private String statusMessage;

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Attachment withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public Attachment withEndpointId(String endpointId) {
        this.setEndpointId(endpointId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Attachment withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Attachment withStatus(AttachmentStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Attachment withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getEndpointId() != null) {
            sb.append("EndpointId: ").append(this.getEndpointId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getEndpointId() == null ^ this.getEndpointId() == null) {
            return false;
        }
        if (other.getEndpointId() != null && !other.getEndpointId().equals(this.getEndpointId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        return other.getStatusMessage() == null || other.getStatusMessage().equals(this.getStatusMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointId() == null ? 0 : this.getEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        return hashCode;
    }

    public Attachment clone() {
        try {
            return (Attachment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

