/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.IPSetReference;
import com.amazonaws.services.networkfirewall.model.transform.ReferenceSetsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ReferenceSets
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, IPSetReference> iPSetReferences;

    public Map<String, IPSetReference> getIPSetReferences() {
        return this.iPSetReferences;
    }

    public void setIPSetReferences(Map<String, IPSetReference> iPSetReferences) {
        this.iPSetReferences = iPSetReferences;
    }

    public ReferenceSets withIPSetReferences(Map<String, IPSetReference> iPSetReferences) {
        this.setIPSetReferences(iPSetReferences);
        return this;
    }

    public ReferenceSets addIPSetReferencesEntry(String key, IPSetReference value) {
        if (null == this.iPSetReferences) {
            this.iPSetReferences = new HashMap<String, IPSetReference>();
        }
        if (this.iPSetReferences.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.iPSetReferences.put(key, value);
        return this;
    }

    public ReferenceSets clearIPSetReferencesEntries() {
        this.iPSetReferences = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIPSetReferences() != null) {
            sb.append("IPSetReferences: ").append(this.getIPSetReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSets)) {
            return false;
        }
        ReferenceSets other = (ReferenceSets)obj;
        if (other.getIPSetReferences() == null ^ this.getIPSetReferences() == null) {
            return false;
        }
        return other.getIPSetReferences() == null || other.getIPSetReferences().equals(this.getIPSetReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIPSetReferences() == null ? 0 : this.getIPSetReferences().hashCode());
        return hashCode;
    }

    public ReferenceSets clone() {
        try {
            return (ReferenceSets)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceSetsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

