/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.ConfigurationSyncState;
import com.amazonaws.services.networkfirewall.model.FirewallStatusValue;
import com.amazonaws.services.networkfirewall.model.SyncState;
import com.amazonaws.services.networkfirewall.model.transform.FirewallStatusMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FirewallStatus
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private String configurationSyncStateSummary;
    private Map<String, SyncState> syncStates;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public FirewallStatus withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public FirewallStatus withStatus(FirewallStatusValue status) {
        this.status = status.toString();
        return this;
    }

    public void setConfigurationSyncStateSummary(String configurationSyncStateSummary) {
        this.configurationSyncStateSummary = configurationSyncStateSummary;
    }

    public String getConfigurationSyncStateSummary() {
        return this.configurationSyncStateSummary;
    }

    public FirewallStatus withConfigurationSyncStateSummary(String configurationSyncStateSummary) {
        this.setConfigurationSyncStateSummary(configurationSyncStateSummary);
        return this;
    }

    public FirewallStatus withConfigurationSyncStateSummary(ConfigurationSyncState configurationSyncStateSummary) {
        this.configurationSyncStateSummary = configurationSyncStateSummary.toString();
        return this;
    }

    public Map<String, SyncState> getSyncStates() {
        return this.syncStates;
    }

    public void setSyncStates(Map<String, SyncState> syncStates) {
        this.syncStates = syncStates;
    }

    public FirewallStatus withSyncStates(Map<String, SyncState> syncStates) {
        this.setSyncStates(syncStates);
        return this;
    }

    public FirewallStatus addSyncStatesEntry(String key, SyncState value) {
        if (null == this.syncStates) {
            this.syncStates = new HashMap<String, SyncState>();
        }
        if (this.syncStates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.syncStates.put(key, value);
        return this;
    }

    public FirewallStatus clearSyncStatesEntries() {
        this.syncStates = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getConfigurationSyncStateSummary() != null) {
            sb.append("ConfigurationSyncStateSummary: ").append(this.getConfigurationSyncStateSummary()).append(",");
        }
        if (this.getSyncStates() != null) {
            sb.append("SyncStates: ").append(this.getSyncStates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatus)) {
            return false;
        }
        FirewallStatus other = (FirewallStatus)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getConfigurationSyncStateSummary() == null ^ this.getConfigurationSyncStateSummary() == null) {
            return false;
        }
        if (other.getConfigurationSyncStateSummary() != null && !other.getConfigurationSyncStateSummary().equals(this.getConfigurationSyncStateSummary())) {
            return false;
        }
        if (other.getSyncStates() == null ^ this.getSyncStates() == null) {
            return false;
        }
        return other.getSyncStates() == null || other.getSyncStates().equals(this.getSyncStates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationSyncStateSummary() == null ? 0 : this.getConfigurationSyncStateSummary().hashCode());
        hashCode = 31 * hashCode + (this.getSyncStates() == null ? 0 : this.getSyncStates().hashCode());
        return hashCode;
    }

    public FirewallStatus clone() {
        try {
            return (FirewallStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FirewallStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

