/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.neptunedata.model.RDFGraphSummary;
import java.util.List;

@SdkInternalApi
public class RDFGraphSummaryMarshaller {
    private static final MarshallingInfo<Long> NUMDISTINCTSUBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numDistinctSubjects").build();
    private static final MarshallingInfo<Long> NUMDISTINCTPREDICATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numDistinctPredicates").build();
    private static final MarshallingInfo<Long> NUMQUADS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numQuads").build();
    private static final MarshallingInfo<Long> NUMCLASSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numClasses").build();
    private static final MarshallingInfo<List> CLASSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("classes").build();
    private static final MarshallingInfo<List> PREDICATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predicates").build();
    private static final MarshallingInfo<List> SUBJECTSTRUCTURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subjectStructures").build();
    private static final RDFGraphSummaryMarshaller instance = new RDFGraphSummaryMarshaller();

    public static RDFGraphSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(RDFGraphSummary rDFGraphSummary, ProtocolMarshaller protocolMarshaller) {
        if (rDFGraphSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rDFGraphSummary.getNumDistinctSubjects(), NUMDISTINCTSUBJECTS_BINDING);
            protocolMarshaller.marshall((Object)rDFGraphSummary.getNumDistinctPredicates(), NUMDISTINCTPREDICATES_BINDING);
            protocolMarshaller.marshall((Object)rDFGraphSummary.getNumQuads(), NUMQUADS_BINDING);
            protocolMarshaller.marshall((Object)rDFGraphSummary.getNumClasses(), NUMCLASSES_BINDING);
            protocolMarshaller.marshall(rDFGraphSummary.getClasses(), CLASSES_BINDING);
            protocolMarshaller.marshall(rDFGraphSummary.getPredicates(), PREDICATES_BINDING);
            protocolMarshaller.marshall(rDFGraphSummary.getSubjectStructures(), SUBJECTSTRUCTURES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

