/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.neptunedata.model.transform.SubjectStructureMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubjectStructure
implements Serializable,
Cloneable,
StructuredPojo {
    private Long count;
    private List<String> predicates;

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getCount() {
        return this.count;
    }

    public SubjectStructure withCount(Long count) {
        this.setCount(count);
        return this;
    }

    public List<String> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(Collection<String> predicates) {
        if (predicates == null) {
            this.predicates = null;
            return;
        }
        this.predicates = new ArrayList<String>(predicates);
    }

    public SubjectStructure withPredicates(String ... predicates) {
        if (this.predicates == null) {
            this.setPredicates(new ArrayList<String>(predicates.length));
        }
        for (String ele : predicates) {
            this.predicates.add(ele);
        }
        return this;
    }

    public SubjectStructure withPredicates(Collection<String> predicates) {
        this.setPredicates(predicates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getPredicates() != null) {
            sb.append("Predicates: ").append(this.getPredicates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectStructure)) {
            return false;
        }
        SubjectStructure other = (SubjectStructure)obj;
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getPredicates() == null ^ this.getPredicates() == null) {
            return false;
        }
        return other.getPredicates() == null || other.getPredicates().equals(this.getPredicates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getPredicates() == null ? 0 : this.getPredicates().hashCode());
        return hashCode;
    }

    public SubjectStructure clone() {
        try {
            return (SubjectStructure)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubjectStructureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

