/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.neptunedata.model.SparqlData;

@SdkInternalApi
public class SparqlDataMarshaller {
    private static final MarshallingInfo<String> STMT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stmt").build();
    private static final SparqlDataMarshaller instance = new SparqlDataMarshaller();

    public static SparqlDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(SparqlData sparqlData, ProtocolMarshaller protocolMarshaller) {
        if (sparqlData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sparqlData.getStmt(), STMT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

