/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptune.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Contains the details of an Amazon Neptune global database.
 * </p>
 * <p>
 * This data type is used as a response element for the <a>CreateGlobalCluster</a>, <a>DescribeGlobalClusters</a>,
 * <a>ModifyGlobalCluster</a>, <a>DeleteGlobalCluster</a>, <a>FailoverGlobalCluster</a>, and
 * <a>RemoveFromGlobalCluster</a> actions.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/GlobalCluster" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GlobalCluster implements Serializable, Cloneable {

    /**
     * <p>
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a
     * global database.
     * </p>
     */
    private String globalClusterIdentifier;
    /**
     * <p>
     * An immutable identifier for the global database that is unique within in all regions. This identifier is found in
     * CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     * </p>
     */
    private String globalClusterResourceId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) for the global database.
     * </p>
     */
    private String globalClusterArn;
    /**
     * <p>
     * Specifies the current state of this global database.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The Neptune database engine used by the global database (<code>"neptune"</code>).
     * </p>
     */
    private String engine;
    /**
     * <p>
     * The Neptune engine version used by the global database.
     * </p>
     */
    private String engineVersion;
    /**
     * <p>
     * The storage encryption setting for the global database.
     * </p>
     */
    private Boolean storageEncrypted;
    /**
     * <p>
     * The deletion protection setting for the global database.
     * </p>
     */
    private Boolean deletionProtection;
    /**
     * <p>
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * </p>
     */
    private java.util.List<GlobalClusterMember> globalClusterMembers;

    /**
     * <p>
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a
     * global database.
     * </p>
     * 
     * @param globalClusterIdentifier
     *        Contains a user-supplied global database cluster identifier. This identifier is the unique key that
     *        identifies a global database.
     */

    public void setGlobalClusterIdentifier(String globalClusterIdentifier) {
        this.globalClusterIdentifier = globalClusterIdentifier;
    }

    /**
     * <p>
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a
     * global database.
     * </p>
     * 
     * @return Contains a user-supplied global database cluster identifier. This identifier is the unique key that
     *         identifies a global database.
     */

    public String getGlobalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    /**
     * <p>
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a
     * global database.
     * </p>
     * 
     * @param globalClusterIdentifier
     *        Contains a user-supplied global database cluster identifier. This identifier is the unique key that
     *        identifies a global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withGlobalClusterIdentifier(String globalClusterIdentifier) {
        setGlobalClusterIdentifier(globalClusterIdentifier);
        return this;
    }

    /**
     * <p>
     * An immutable identifier for the global database that is unique within in all regions. This identifier is found in
     * CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     * </p>
     * 
     * @param globalClusterResourceId
     *        An immutable identifier for the global database that is unique within in all regions. This identifier is
     *        found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */

    public void setGlobalClusterResourceId(String globalClusterResourceId) {
        this.globalClusterResourceId = globalClusterResourceId;
    }

    /**
     * <p>
     * An immutable identifier for the global database that is unique within in all regions. This identifier is found in
     * CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     * </p>
     * 
     * @return An immutable identifier for the global database that is unique within in all regions. This identifier is
     *         found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */

    public String getGlobalClusterResourceId() {
        return this.globalClusterResourceId;
    }

    /**
     * <p>
     * An immutable identifier for the global database that is unique within in all regions. This identifier is found in
     * CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     * </p>
     * 
     * @param globalClusterResourceId
     *        An immutable identifier for the global database that is unique within in all regions. This identifier is
     *        found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withGlobalClusterResourceId(String globalClusterResourceId) {
        setGlobalClusterResourceId(globalClusterResourceId);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the global database.
     * </p>
     * 
     * @param globalClusterArn
     *        The Amazon Resource Name (ARN) for the global database.
     */

    public void setGlobalClusterArn(String globalClusterArn) {
        this.globalClusterArn = globalClusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the global database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the global database.
     */

    public String getGlobalClusterArn() {
        return this.globalClusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the global database.
     * </p>
     * 
     * @param globalClusterArn
     *        The Amazon Resource Name (ARN) for the global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withGlobalClusterArn(String globalClusterArn) {
        setGlobalClusterArn(globalClusterArn);
        return this;
    }

    /**
     * <p>
     * Specifies the current state of this global database.
     * </p>
     * 
     * @param status
     *        Specifies the current state of this global database.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Specifies the current state of this global database.
     * </p>
     * 
     * @return Specifies the current state of this global database.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Specifies the current state of this global database.
     * </p>
     * 
     * @param status
     *        Specifies the current state of this global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The Neptune database engine used by the global database (<code>"neptune"</code>).
     * </p>
     * 
     * @param engine
     *        The Neptune database engine used by the global database (<code>"neptune"</code>).
     */

    public void setEngine(String engine) {
        this.engine = engine;
    }

    /**
     * <p>
     * The Neptune database engine used by the global database (<code>"neptune"</code>).
     * </p>
     * 
     * @return The Neptune database engine used by the global database (<code>"neptune"</code>).
     */

    public String getEngine() {
        return this.engine;
    }

    /**
     * <p>
     * The Neptune database engine used by the global database (<code>"neptune"</code>).
     * </p>
     * 
     * @param engine
     *        The Neptune database engine used by the global database (<code>"neptune"</code>).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withEngine(String engine) {
        setEngine(engine);
        return this;
    }

    /**
     * <p>
     * The Neptune engine version used by the global database.
     * </p>
     * 
     * @param engineVersion
     *        The Neptune engine version used by the global database.
     */

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    /**
     * <p>
     * The Neptune engine version used by the global database.
     * </p>
     * 
     * @return The Neptune engine version used by the global database.
     */

    public String getEngineVersion() {
        return this.engineVersion;
    }

    /**
     * <p>
     * The Neptune engine version used by the global database.
     * </p>
     * 
     * @param engineVersion
     *        The Neptune engine version used by the global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withEngineVersion(String engineVersion) {
        setEngineVersion(engineVersion);
        return this;
    }

    /**
     * <p>
     * The storage encryption setting for the global database.
     * </p>
     * 
     * @param storageEncrypted
     *        The storage encryption setting for the global database.
     */

    public void setStorageEncrypted(Boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    /**
     * <p>
     * The storage encryption setting for the global database.
     * </p>
     * 
     * @return The storage encryption setting for the global database.
     */

    public Boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    /**
     * <p>
     * The storage encryption setting for the global database.
     * </p>
     * 
     * @param storageEncrypted
     *        The storage encryption setting for the global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withStorageEncrypted(Boolean storageEncrypted) {
        setStorageEncrypted(storageEncrypted);
        return this;
    }

    /**
     * <p>
     * The storage encryption setting for the global database.
     * </p>
     * 
     * @return The storage encryption setting for the global database.
     */

    public Boolean isStorageEncrypted() {
        return this.storageEncrypted;
    }

    /**
     * <p>
     * The deletion protection setting for the global database.
     * </p>
     * 
     * @param deletionProtection
     *        The deletion protection setting for the global database.
     */

    public void setDeletionProtection(Boolean deletionProtection) {
        this.deletionProtection = deletionProtection;
    }

    /**
     * <p>
     * The deletion protection setting for the global database.
     * </p>
     * 
     * @return The deletion protection setting for the global database.
     */

    public Boolean getDeletionProtection() {
        return this.deletionProtection;
    }

    /**
     * <p>
     * The deletion protection setting for the global database.
     * </p>
     * 
     * @param deletionProtection
     *        The deletion protection setting for the global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withDeletionProtection(Boolean deletionProtection) {
        setDeletionProtection(deletionProtection);
        return this;
    }

    /**
     * <p>
     * The deletion protection setting for the global database.
     * </p>
     * 
     * @return The deletion protection setting for the global database.
     */

    public Boolean isDeletionProtection() {
        return this.deletionProtection;
    }

    /**
     * <p>
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * </p>
     * 
     * @return A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     */

    public java.util.List<GlobalClusterMember> getGlobalClusterMembers() {
        return globalClusterMembers;
    }

    /**
     * <p>
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * </p>
     * 
     * @param globalClusterMembers
     *        A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     */

    public void setGlobalClusterMembers(java.util.Collection<GlobalClusterMember> globalClusterMembers) {
        if (globalClusterMembers == null) {
            this.globalClusterMembers = null;
            return;
        }

        this.globalClusterMembers = new java.util.ArrayList<GlobalClusterMember>(globalClusterMembers);
    }

    /**
     * <p>
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setGlobalClusterMembers(java.util.Collection)} or {@link #withGlobalClusterMembers(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param globalClusterMembers
     *        A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withGlobalClusterMembers(GlobalClusterMember... globalClusterMembers) {
        if (this.globalClusterMembers == null) {
            setGlobalClusterMembers(new java.util.ArrayList<GlobalClusterMember>(globalClusterMembers.length));
        }
        for (GlobalClusterMember ele : globalClusterMembers) {
            this.globalClusterMembers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * </p>
     * 
     * @param globalClusterMembers
     *        A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GlobalCluster withGlobalClusterMembers(java.util.Collection<GlobalClusterMember> globalClusterMembers) {
        setGlobalClusterMembers(globalClusterMembers);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGlobalClusterIdentifier() != null)
            sb.append("GlobalClusterIdentifier: ").append(getGlobalClusterIdentifier()).append(",");
        if (getGlobalClusterResourceId() != null)
            sb.append("GlobalClusterResourceId: ").append(getGlobalClusterResourceId()).append(",");
        if (getGlobalClusterArn() != null)
            sb.append("GlobalClusterArn: ").append(getGlobalClusterArn()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getEngine() != null)
            sb.append("Engine: ").append(getEngine()).append(",");
        if (getEngineVersion() != null)
            sb.append("EngineVersion: ").append(getEngineVersion()).append(",");
        if (getStorageEncrypted() != null)
            sb.append("StorageEncrypted: ").append(getStorageEncrypted()).append(",");
        if (getDeletionProtection() != null)
            sb.append("DeletionProtection: ").append(getDeletionProtection()).append(",");
        if (getGlobalClusterMembers() != null)
            sb.append("GlobalClusterMembers: ").append(getGlobalClusterMembers());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GlobalCluster == false)
            return false;
        GlobalCluster other = (GlobalCluster) obj;
        if (other.getGlobalClusterIdentifier() == null ^ this.getGlobalClusterIdentifier() == null)
            return false;
        if (other.getGlobalClusterIdentifier() != null && other.getGlobalClusterIdentifier().equals(this.getGlobalClusterIdentifier()) == false)
            return false;
        if (other.getGlobalClusterResourceId() == null ^ this.getGlobalClusterResourceId() == null)
            return false;
        if (other.getGlobalClusterResourceId() != null && other.getGlobalClusterResourceId().equals(this.getGlobalClusterResourceId()) == false)
            return false;
        if (other.getGlobalClusterArn() == null ^ this.getGlobalClusterArn() == null)
            return false;
        if (other.getGlobalClusterArn() != null && other.getGlobalClusterArn().equals(this.getGlobalClusterArn()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getEngine() == null ^ this.getEngine() == null)
            return false;
        if (other.getEngine() != null && other.getEngine().equals(this.getEngine()) == false)
            return false;
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null)
            return false;
        if (other.getEngineVersion() != null && other.getEngineVersion().equals(this.getEngineVersion()) == false)
            return false;
        if (other.getStorageEncrypted() == null ^ this.getStorageEncrypted() == null)
            return false;
        if (other.getStorageEncrypted() != null && other.getStorageEncrypted().equals(this.getStorageEncrypted()) == false)
            return false;
        if (other.getDeletionProtection() == null ^ this.getDeletionProtection() == null)
            return false;
        if (other.getDeletionProtection() != null && other.getDeletionProtection().equals(this.getDeletionProtection()) == false)
            return false;
        if (other.getGlobalClusterMembers() == null ^ this.getGlobalClusterMembers() == null)
            return false;
        if (other.getGlobalClusterMembers() != null && other.getGlobalClusterMembers().equals(this.getGlobalClusterMembers()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGlobalClusterIdentifier() == null) ? 0 : getGlobalClusterIdentifier().hashCode());
        hashCode = prime * hashCode + ((getGlobalClusterResourceId() == null) ? 0 : getGlobalClusterResourceId().hashCode());
        hashCode = prime * hashCode + ((getGlobalClusterArn() == null) ? 0 : getGlobalClusterArn().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getEngine() == null) ? 0 : getEngine().hashCode());
        hashCode = prime * hashCode + ((getEngineVersion() == null) ? 0 : getEngineVersion().hashCode());
        hashCode = prime * hashCode + ((getStorageEncrypted() == null) ? 0 : getStorageEncrypted().hashCode());
        hashCode = prime * hashCode + ((getDeletionProtection() == null) ? 0 : getDeletionProtection().hashCode());
        hashCode = prime * hashCode + ((getGlobalClusterMembers() == null) ? 0 : getGlobalClusterMembers().hashCode());
        return hashCode;
    }

    @Override
    public GlobalCluster clone() {
        try {
            return (GlobalCluster) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
