/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptune.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * RemoveFromGlobalClusterRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RemoveFromGlobalClusterRequestMarshaller implements Marshaller<Request<RemoveFromGlobalClusterRequest>, RemoveFromGlobalClusterRequest> {

    public Request<RemoveFromGlobalClusterRequest> marshall(RemoveFromGlobalClusterRequest removeFromGlobalClusterRequest) {

        if (removeFromGlobalClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RemoveFromGlobalClusterRequest> request = new DefaultRequest<RemoveFromGlobalClusterRequest>(removeFromGlobalClusterRequest, "AmazonNeptune");
        request.addParameter("Action", "RemoveFromGlobalCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (removeFromGlobalClusterRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString(removeFromGlobalClusterRequest.getGlobalClusterIdentifier()));
        }

        if (removeFromGlobalClusterRequest.getDbClusterIdentifier() != null) {
            request.addParameter("DbClusterIdentifier", StringUtils.fromString(removeFromGlobalClusterRequest.getDbClusterIdentifier()));
        }

        return request;
    }

}
