/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.neptune.AmazonNeptune;
import com.amazonaws.services.neptune.model.DescribeDBInstancesRequest;
import com.amazonaws.services.neptune.waiters.DBInstanceAvailable;
import com.amazonaws.services.neptune.waiters.DBInstanceDeleted;
import com.amazonaws.services.neptune.waiters.DescribeDBInstancesFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonNeptuneWaiters {
    private final AmazonNeptune client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonNeptuneWaiters");

    @SdkInternalApi
    public AmazonNeptuneWaiters(AmazonNeptune client) {
        this.client = client;
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDBInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DBInstanceAvailable.IsAvailableMatcher(), new DBInstanceAvailable.IsDeletedMatcher(), new DBInstanceAvailable.IsDeletingMatcher(), new DBInstanceAvailable.IsFailedMatcher(), new DBInstanceAvailable.IsIncompatiblerestoreMatcher(), new DBInstanceAvailable.IsIncompatibleparametersMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDBInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DBInstanceDeleted.IsDeletedMatcher(), new DBInstanceDeleted.IsDBInstanceNotFoundMatcher(), new DBInstanceDeleted.IsCreatingMatcher(), new DBInstanceDeleted.IsModifyingMatcher(), new DBInstanceDeleted.IsRebootingMatcher(), new DBInstanceDeleted.IsResettingmastercredentialsMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

