/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.services.neptune.model.UpgradeTarget;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class UpgradeTargetStaxUnmarshaller
implements Unmarshaller<UpgradeTarget, StaxUnmarshallerContext> {
    private static UpgradeTargetStaxUnmarshaller instance;

    public UpgradeTarget unmarshall(StaxUnmarshallerContext context) throws Exception {
        UpgradeTarget upgradeTarget = new UpgradeTarget();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return upgradeTarget;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Engine", targetDepth)) {
                    upgradeTarget.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    upgradeTarget.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    upgradeTarget.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoUpgrade", targetDepth)) {
                    upgradeTarget.setAutoUpgrade(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsMajorVersionUpgrade", targetDepth)) continue;
                upgradeTarget.setIsMajorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return upgradeTarget;
    }

    public static UpgradeTargetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new UpgradeTargetStaxUnmarshaller();
        }
        return instance;
    }
}

