/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mq.model.EncryptionOptions;

@SdkInternalApi
public class EncryptionOptionsMarshaller {
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").build();
    private static final MarshallingInfo<Boolean> USEAWSOWNEDKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useAwsOwnedKey").build();
    private static final EncryptionOptionsMarshaller instance = new EncryptionOptionsMarshaller();

    public static EncryptionOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncryptionOptions encryptionOptions, ProtocolMarshaller protocolMarshaller) {
        if (encryptionOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)encryptionOptions.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)encryptionOptions.getUseAwsOwnedKey(), USEAWSOWNEDKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

