/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations;

import javax.annotation.Generated;

import com.amazonaws.services.migrationhubstrategyrecommendations.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMigrationHubStrategyRecommendations}. Convenient method forms pass through to
 * the corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMigrationHubStrategyRecommendations implements AWSMigrationHubStrategyRecommendations {

    protected AbstractAWSMigrationHubStrategyRecommendations() {
    }

    @Override
    public GetApplicationComponentDetailsResult getApplicationComponentDetails(GetApplicationComponentDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationComponentStrategiesResult getApplicationComponentStrategies(GetApplicationComponentStrategiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssessmentResult getAssessment(GetAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImportFileTaskResult getImportFileTask(GetImportFileTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLatestAssessmentIdResult getLatestAssessmentId(GetLatestAssessmentIdRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPortfolioPreferencesResult getPortfolioPreferences(GetPortfolioPreferencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPortfolioSummaryResult getPortfolioSummary(GetPortfolioSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRecommendationReportDetailsResult getRecommendationReportDetails(GetRecommendationReportDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServerDetailsResult getServerDetails(GetServerDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServerStrategiesResult getServerStrategies(GetServerStrategiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationComponentsResult listApplicationComponents(ListApplicationComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCollectorsResult listCollectors(ListCollectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImportFileTaskResult listImportFileTask(ListImportFileTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServersResult listServers(ListServersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPortfolioPreferencesResult putPortfolioPreferences(PutPortfolioPreferencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAssessmentResult startAssessment(StartAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartImportFileTaskResult startImportFileTask(StartImportFileTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartRecommendationReportGenerationResult startRecommendationReportGeneration(StartRecommendationReportGenerationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopAssessmentResult stopAssessment(StopAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApplicationComponentConfigResult updateApplicationComponentConfig(UpdateApplicationComponentConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServerConfigResult updateServerConfig(UpdateServerConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
