/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.migrationhubstrategyrecommendations.model.AssessmentTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartAssessmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AssessmentTarget> assessmentTargets;
    private String s3bucketForAnalysisData;
    private String s3bucketForReportData;

    public List<AssessmentTarget> getAssessmentTargets() {
        return this.assessmentTargets;
    }

    public void setAssessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
        if (assessmentTargets == null) {
            this.assessmentTargets = null;
            return;
        }
        this.assessmentTargets = new ArrayList<AssessmentTarget>(assessmentTargets);
    }

    public StartAssessmentRequest withAssessmentTargets(AssessmentTarget ... assessmentTargets) {
        if (this.assessmentTargets == null) {
            this.setAssessmentTargets(new ArrayList<AssessmentTarget>(assessmentTargets.length));
        }
        for (AssessmentTarget ele : assessmentTargets) {
            this.assessmentTargets.add(ele);
        }
        return this;
    }

    public StartAssessmentRequest withAssessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
        this.setAssessmentTargets(assessmentTargets);
        return this;
    }

    public void setS3bucketForAnalysisData(String s3bucketForAnalysisData) {
        this.s3bucketForAnalysisData = s3bucketForAnalysisData;
    }

    public String getS3bucketForAnalysisData() {
        return this.s3bucketForAnalysisData;
    }

    public StartAssessmentRequest withS3bucketForAnalysisData(String s3bucketForAnalysisData) {
        this.setS3bucketForAnalysisData(s3bucketForAnalysisData);
        return this;
    }

    public void setS3bucketForReportData(String s3bucketForReportData) {
        this.s3bucketForReportData = s3bucketForReportData;
    }

    public String getS3bucketForReportData() {
        return this.s3bucketForReportData;
    }

    public StartAssessmentRequest withS3bucketForReportData(String s3bucketForReportData) {
        this.setS3bucketForReportData(s3bucketForReportData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssessmentTargets() != null) {
            sb.append("AssessmentTargets: ").append(this.getAssessmentTargets()).append(",");
        }
        if (this.getS3bucketForAnalysisData() != null) {
            sb.append("S3bucketForAnalysisData: ").append(this.getS3bucketForAnalysisData()).append(",");
        }
        if (this.getS3bucketForReportData() != null) {
            sb.append("S3bucketForReportData: ").append(this.getS3bucketForReportData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRequest)) {
            return false;
        }
        StartAssessmentRequest other = (StartAssessmentRequest)obj;
        if (other.getAssessmentTargets() == null ^ this.getAssessmentTargets() == null) {
            return false;
        }
        if (other.getAssessmentTargets() != null && !other.getAssessmentTargets().equals(this.getAssessmentTargets())) {
            return false;
        }
        if (other.getS3bucketForAnalysisData() == null ^ this.getS3bucketForAnalysisData() == null) {
            return false;
        }
        if (other.getS3bucketForAnalysisData() != null && !other.getS3bucketForAnalysisData().equals(this.getS3bucketForAnalysisData())) {
            return false;
        }
        if (other.getS3bucketForReportData() == null ^ this.getS3bucketForReportData() == null) {
            return false;
        }
        return other.getS3bucketForReportData() == null || other.getS3bucketForReportData().equals(this.getS3bucketForReportData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssessmentTargets() == null ? 0 : this.getAssessmentTargets().hashCode());
        hashCode = 31 * hashCode + (this.getS3bucketForAnalysisData() == null ? 0 : this.getS3bucketForAnalysisData().hashCode());
        hashCode = 31 * hashCode + (this.getS3bucketForReportData() == null ? 0 : this.getS3bucketForReportData().hashCode());
        return hashCode;
    }

    public StartAssessmentRequest clone() {
        return (StartAssessmentRequest)super.clone();
    }
}

