/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mgn.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mgn.model.SsmExternalParameter;
import com.amazonaws.services.mgn.model.SsmParameterStoreParameter;
import com.amazonaws.services.mgn.model.transform.SsmDocumentMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SsmDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private String actionName;
    private Map<String, SsmExternalParameter> externalParameters;
    private Boolean mustSucceedForCutover;
    private Map<String, List<SsmParameterStoreParameter>> parameters;
    private String ssmDocumentName;
    private Integer timeoutSeconds;

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public SsmDocument withActionName(String actionName) {
        this.setActionName(actionName);
        return this;
    }

    public Map<String, SsmExternalParameter> getExternalParameters() {
        return this.externalParameters;
    }

    public void setExternalParameters(Map<String, SsmExternalParameter> externalParameters) {
        this.externalParameters = externalParameters;
    }

    public SsmDocument withExternalParameters(Map<String, SsmExternalParameter> externalParameters) {
        this.setExternalParameters(externalParameters);
        return this;
    }

    public SsmDocument addExternalParametersEntry(String key, SsmExternalParameter value) {
        if (null == this.externalParameters) {
            this.externalParameters = new HashMap<String, SsmExternalParameter>();
        }
        if (this.externalParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.externalParameters.put(key, value);
        return this;
    }

    public SsmDocument clearExternalParametersEntries() {
        this.externalParameters = null;
        return this;
    }

    public void setMustSucceedForCutover(Boolean mustSucceedForCutover) {
        this.mustSucceedForCutover = mustSucceedForCutover;
    }

    public Boolean getMustSucceedForCutover() {
        return this.mustSucceedForCutover;
    }

    public SsmDocument withMustSucceedForCutover(Boolean mustSucceedForCutover) {
        this.setMustSucceedForCutover(mustSucceedForCutover);
        return this;
    }

    public Boolean isMustSucceedForCutover() {
        return this.mustSucceedForCutover;
    }

    public Map<String, List<SsmParameterStoreParameter>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<SsmParameterStoreParameter>> parameters) {
        this.parameters = parameters;
    }

    public SsmDocument withParameters(Map<String, List<SsmParameterStoreParameter>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SsmDocument addParametersEntry(String key, List<SsmParameterStoreParameter> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<SsmParameterStoreParameter>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SsmDocument clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setSsmDocumentName(String ssmDocumentName) {
        this.ssmDocumentName = ssmDocumentName;
    }

    public String getSsmDocumentName() {
        return this.ssmDocumentName;
    }

    public SsmDocument withSsmDocumentName(String ssmDocumentName) {
        this.setSsmDocumentName(ssmDocumentName);
        return this;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public SsmDocument withTimeoutSeconds(Integer timeoutSeconds) {
        this.setTimeoutSeconds(timeoutSeconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionName() != null) {
            sb.append("ActionName: ").append(this.getActionName()).append(",");
        }
        if (this.getExternalParameters() != null) {
            sb.append("ExternalParameters: ").append(this.getExternalParameters()).append(",");
        }
        if (this.getMustSucceedForCutover() != null) {
            sb.append("MustSucceedForCutover: ").append(this.getMustSucceedForCutover()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getSsmDocumentName() != null) {
            sb.append("SsmDocumentName: ").append(this.getSsmDocumentName()).append(",");
        }
        if (this.getTimeoutSeconds() != null) {
            sb.append("TimeoutSeconds: ").append(this.getTimeoutSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmDocument)) {
            return false;
        }
        SsmDocument other = (SsmDocument)obj;
        if (other.getActionName() == null ^ this.getActionName() == null) {
            return false;
        }
        if (other.getActionName() != null && !other.getActionName().equals(this.getActionName())) {
            return false;
        }
        if (other.getExternalParameters() == null ^ this.getExternalParameters() == null) {
            return false;
        }
        if (other.getExternalParameters() != null && !other.getExternalParameters().equals(this.getExternalParameters())) {
            return false;
        }
        if (other.getMustSucceedForCutover() == null ^ this.getMustSucceedForCutover() == null) {
            return false;
        }
        if (other.getMustSucceedForCutover() != null && !other.getMustSucceedForCutover().equals(this.getMustSucceedForCutover())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getSsmDocumentName() == null ^ this.getSsmDocumentName() == null) {
            return false;
        }
        if (other.getSsmDocumentName() != null && !other.getSsmDocumentName().equals(this.getSsmDocumentName())) {
            return false;
        }
        if (other.getTimeoutSeconds() == null ^ this.getTimeoutSeconds() == null) {
            return false;
        }
        return other.getTimeoutSeconds() == null || other.getTimeoutSeconds().equals(this.getTimeoutSeconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionName() == null ? 0 : this.getActionName().hashCode());
        hashCode = 31 * hashCode + (this.getExternalParameters() == null ? 0 : this.getExternalParameters().hashCode());
        hashCode = 31 * hashCode + (this.getMustSucceedForCutover() == null ? 0 : this.getMustSucceedForCutover().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getSsmDocumentName() == null ? 0 : this.getSsmDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutSeconds() == null ? 0 : this.getTimeoutSeconds().hashCode());
        return hashCode;
    }

    public SsmDocument clone() {
        try {
            return (SsmDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SsmDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

