/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.memorydb.model.ReservedNode;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ReservedNodeMarshaller {
    private static final MarshallingInfo<String> RESERVATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservationId").build();
    private static final MarshallingInfo<String> RESERVEDNODESOFFERINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedNodesOfferingId").build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").build();
    private static final MarshallingInfo<Double> FIXEDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedPrice").build();
    private static final MarshallingInfo<Integer> NODECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeCount").build();
    private static final MarshallingInfo<String> OFFERINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OfferingType").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<List> RECURRINGCHARGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurringCharges").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ARN").build();
    private static final ReservedNodeMarshaller instance = new ReservedNodeMarshaller();

    public static ReservedNodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReservedNode reservedNode, ProtocolMarshaller protocolMarshaller) {
        if (reservedNode == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)reservedNode.getReservationId(), RESERVATIONID_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getReservedNodesOfferingId(), RESERVEDNODESOFFERINGID_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getNodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getDuration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getFixedPrice(), FIXEDPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getNodeCount(), NODECOUNT_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getOfferingType(), OFFERINGTYPE_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getState(), STATE_BINDING);
            protocolMarshaller.marshall(reservedNode.getRecurringCharges(), RECURRINGCHARGES_BINDING);
            protocolMarshaller.marshall((Object)reservedNode.getARN(), ARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

