/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.ShardDetail;
import com.amazonaws.services.memorydb.model.transform.ClusterConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String nodeType;
    private String engineVersion;
    private String maintenanceWindow;
    private String topicArn;
    private Integer port;
    private String parameterGroupName;
    private String subnetGroupName;
    private String vpcId;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private Integer numShards;
    private List<ShardDetail> shards;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ClusterConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ClusterConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public ClusterConfiguration withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public ClusterConfiguration withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setMaintenanceWindow(String maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
    }

    public String getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ClusterConfiguration withMaintenanceWindow(String maintenanceWindow) {
        this.setMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public ClusterConfiguration withTopicArn(String topicArn) {
        this.setTopicArn(topicArn);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public ClusterConfiguration withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setParameterGroupName(String parameterGroupName) {
        this.parameterGroupName = parameterGroupName;
    }

    public String getParameterGroupName() {
        return this.parameterGroupName;
    }

    public ClusterConfiguration withParameterGroupName(String parameterGroupName) {
        this.setParameterGroupName(parameterGroupName);
        return this;
    }

    public void setSubnetGroupName(String subnetGroupName) {
        this.subnetGroupName = subnetGroupName;
    }

    public String getSubnetGroupName() {
        return this.subnetGroupName;
    }

    public ClusterConfiguration withSubnetGroupName(String subnetGroupName) {
        this.setSubnetGroupName(subnetGroupName);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public ClusterConfiguration withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public ClusterConfiguration withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public ClusterConfiguration withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public void setNumShards(Integer numShards) {
        this.numShards = numShards;
    }

    public Integer getNumShards() {
        return this.numShards;
    }

    public ClusterConfiguration withNumShards(Integer numShards) {
        this.setNumShards(numShards);
        return this;
    }

    public List<ShardDetail> getShards() {
        return this.shards;
    }

    public void setShards(Collection<ShardDetail> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        this.shards = new ArrayList<ShardDetail>(shards);
    }

    public ClusterConfiguration withShards(ShardDetail ... shards) {
        if (this.shards == null) {
            this.setShards(new ArrayList<ShardDetail>(shards.length));
        }
        for (ShardDetail ele : shards) {
            this.shards.add(ele);
        }
        return this;
    }

    public ClusterConfiguration withShards(Collection<ShardDetail> shards) {
        this.setShards(shards);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: ").append(this.getNodeType()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getMaintenanceWindow() != null) {
            sb.append("MaintenanceWindow: ").append(this.getMaintenanceWindow()).append(",");
        }
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: ").append(this.getTopicArn()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getParameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.getParameterGroupName()).append(",");
        }
        if (this.getSubnetGroupName() != null) {
            sb.append("SubnetGroupName: ").append(this.getSubnetGroupName()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.getSnapshotRetentionLimit()).append(",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.getSnapshotWindow()).append(",");
        }
        if (this.getNumShards() != null) {
            sb.append("NumShards: ").append(this.getNumShards()).append(",");
        }
        if (this.getShards() != null) {
            sb.append("Shards: ").append(this.getShards());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterConfiguration)) {
            return false;
        }
        ClusterConfiguration other = (ClusterConfiguration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getMaintenanceWindow() == null ^ this.getMaintenanceWindow() == null) {
            return false;
        }
        if (other.getMaintenanceWindow() != null && !other.getMaintenanceWindow().equals(this.getMaintenanceWindow())) {
            return false;
        }
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getParameterGroupName() == null ^ this.getParameterGroupName() == null) {
            return false;
        }
        if (other.getParameterGroupName() != null && !other.getParameterGroupName().equals(this.getParameterGroupName())) {
            return false;
        }
        if (other.getSubnetGroupName() == null ^ this.getSubnetGroupName() == null) {
            return false;
        }
        if (other.getSubnetGroupName() != null && !other.getSubnetGroupName().equals(this.getSubnetGroupName())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getNumShards() == null ^ this.getNumShards() == null) {
            return false;
        }
        if (other.getNumShards() != null && !other.getNumShards().equals(this.getNumShards())) {
            return false;
        }
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        return other.getShards() == null || other.getShards().equals(this.getShards());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceWindow() == null ? 0 : this.getMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getParameterGroupName() == null ? 0 : this.getParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetGroupName() == null ? 0 : this.getSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getNumShards() == null ? 0 : this.getNumShards().hashCode());
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : this.getShards().hashCode());
        return hashCode;
    }

    public ClusterConfiguration clone() {
        try {
            return (ClusterConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

