/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medicalimaging.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medicalimaging.model.DICOMTags;

@SdkInternalApi
public class DICOMTagsMarshaller {
    private static final MarshallingInfo<String> DICOMPATIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMPatientId").build();
    private static final MarshallingInfo<String> DICOMPATIENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMPatientName").build();
    private static final MarshallingInfo<String> DICOMPATIENTBIRTHDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMPatientBirthDate").build();
    private static final MarshallingInfo<String> DICOMPATIENTSEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMPatientSex").build();
    private static final MarshallingInfo<String> DICOMSTUDYINSTANCEUID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMStudyInstanceUID").build();
    private static final MarshallingInfo<String> DICOMSTUDYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMStudyId").build();
    private static final MarshallingInfo<String> DICOMSTUDYDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMStudyDescription").build();
    private static final MarshallingInfo<Integer> DICOMNUMBEROFSTUDYRELATEDSERIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMNumberOfStudyRelatedSeries").build();
    private static final MarshallingInfo<Integer> DICOMNUMBEROFSTUDYRELATEDINSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMNumberOfStudyRelatedInstances").build();
    private static final MarshallingInfo<String> DICOMACCESSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMAccessionNumber").build();
    private static final MarshallingInfo<String> DICOMSERIESINSTANCEUID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMSeriesInstanceUID").build();
    private static final MarshallingInfo<String> DICOMSERIESMODALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMSeriesModality").build();
    private static final MarshallingInfo<String> DICOMSERIESBODYPART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMSeriesBodyPart").build();
    private static final MarshallingInfo<Integer> DICOMSERIESNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMSeriesNumber").build();
    private static final MarshallingInfo<String> DICOMSTUDYDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMStudyDate").build();
    private static final MarshallingInfo<String> DICOMSTUDYTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DICOMStudyTime").build();
    private static final DICOMTagsMarshaller instance = new DICOMTagsMarshaller();

    public static DICOMTagsMarshaller getInstance() {
        return instance;
    }

    public void marshall(DICOMTags dICOMTags, ProtocolMarshaller protocolMarshaller) {
        if (dICOMTags == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMPatientId(), DICOMPATIENTID_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMPatientName(), DICOMPATIENTNAME_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMPatientBirthDate(), DICOMPATIENTBIRTHDATE_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMPatientSex(), DICOMPATIENTSEX_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMStudyInstanceUID(), DICOMSTUDYINSTANCEUID_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMStudyId(), DICOMSTUDYID_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMStudyDescription(), DICOMSTUDYDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMNumberOfStudyRelatedSeries(), DICOMNUMBEROFSTUDYRELATEDSERIES_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMNumberOfStudyRelatedInstances(), DICOMNUMBEROFSTUDYRELATEDINSTANCES_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMAccessionNumber(), DICOMACCESSIONNUMBER_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMSeriesInstanceUID(), DICOMSERIESINSTANCEUID_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMSeriesModality(), DICOMSERIESMODALITY_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMSeriesBodyPart(), DICOMSERIESBODYPART_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMSeriesNumber(), DICOMSERIESNUMBER_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMStudyDate(), DICOMSTUDYDATE_BINDING);
            protocolMarshaller.marshall((Object)dICOMTags.getDICOMStudyTime(), DICOMSTUDYTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

