/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediatailor.AWSMediaTailorAsync;
import com.amazonaws.services.mediatailor.AWSMediaTailorAsyncClientBuilder;
import com.amazonaws.services.mediatailor.AWSMediaTailorClient;
import com.amazonaws.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.CreateChannelRequest;
import com.amazonaws.services.mediatailor.model.CreateChannelResult;
import com.amazonaws.services.mediatailor.model.CreateProgramRequest;
import com.amazonaws.services.mediatailor.model.CreateProgramResult;
import com.amazonaws.services.mediatailor.model.CreateSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.CreateSourceLocationResult;
import com.amazonaws.services.mediatailor.model.CreateVodSourceRequest;
import com.amazonaws.services.mediatailor.model.CreateVodSourceResult;
import com.amazonaws.services.mediatailor.model.DeleteChannelPolicyRequest;
import com.amazonaws.services.mediatailor.model.DeleteChannelPolicyResult;
import com.amazonaws.services.mediatailor.model.DeleteChannelRequest;
import com.amazonaws.services.mediatailor.model.DeleteChannelResult;
import com.amazonaws.services.mediatailor.model.DeletePlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.DeletePlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.DeleteProgramRequest;
import com.amazonaws.services.mediatailor.model.DeleteProgramResult;
import com.amazonaws.services.mediatailor.model.DeleteSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.DeleteSourceLocationResult;
import com.amazonaws.services.mediatailor.model.DeleteVodSourceRequest;
import com.amazonaws.services.mediatailor.model.DeleteVodSourceResult;
import com.amazonaws.services.mediatailor.model.DescribeChannelRequest;
import com.amazonaws.services.mediatailor.model.DescribeChannelResult;
import com.amazonaws.services.mediatailor.model.DescribeProgramRequest;
import com.amazonaws.services.mediatailor.model.DescribeProgramResult;
import com.amazonaws.services.mediatailor.model.DescribeSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.DescribeSourceLocationResult;
import com.amazonaws.services.mediatailor.model.DescribeVodSourceRequest;
import com.amazonaws.services.mediatailor.model.DescribeVodSourceResult;
import com.amazonaws.services.mediatailor.model.GetChannelPolicyRequest;
import com.amazonaws.services.mediatailor.model.GetChannelPolicyResult;
import com.amazonaws.services.mediatailor.model.GetChannelScheduleRequest;
import com.amazonaws.services.mediatailor.model.GetChannelScheduleResult;
import com.amazonaws.services.mediatailor.model.GetPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.GetPlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.ListAlertsRequest;
import com.amazonaws.services.mediatailor.model.ListAlertsResult;
import com.amazonaws.services.mediatailor.model.ListChannelsRequest;
import com.amazonaws.services.mediatailor.model.ListChannelsResult;
import com.amazonaws.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import com.amazonaws.services.mediatailor.model.ListPlaybackConfigurationsResult;
import com.amazonaws.services.mediatailor.model.ListSourceLocationsRequest;
import com.amazonaws.services.mediatailor.model.ListSourceLocationsResult;
import com.amazonaws.services.mediatailor.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediatailor.model.ListTagsForResourceResult;
import com.amazonaws.services.mediatailor.model.ListVodSourcesRequest;
import com.amazonaws.services.mediatailor.model.ListVodSourcesResult;
import com.amazonaws.services.mediatailor.model.PutChannelPolicyRequest;
import com.amazonaws.services.mediatailor.model.PutChannelPolicyResult;
import com.amazonaws.services.mediatailor.model.PutPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.PutPlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.StartChannelRequest;
import com.amazonaws.services.mediatailor.model.StartChannelResult;
import com.amazonaws.services.mediatailor.model.StopChannelRequest;
import com.amazonaws.services.mediatailor.model.StopChannelResult;
import com.amazonaws.services.mediatailor.model.TagResourceRequest;
import com.amazonaws.services.mediatailor.model.TagResourceResult;
import com.amazonaws.services.mediatailor.model.UntagResourceRequest;
import com.amazonaws.services.mediatailor.model.UntagResourceResult;
import com.amazonaws.services.mediatailor.model.UpdateChannelRequest;
import com.amazonaws.services.mediatailor.model.UpdateChannelResult;
import com.amazonaws.services.mediatailor.model.UpdateSourceLocationRequest;
import com.amazonaws.services.mediatailor.model.UpdateSourceLocationResult;
import com.amazonaws.services.mediatailor.model.UpdateVodSourceRequest;
import com.amazonaws.services.mediatailor.model.UpdateVodSourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaTailorAsyncClient
extends AWSMediaTailorClient
implements AWSMediaTailorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaTailorAsyncClientBuilder asyncBuilder() {
        return AWSMediaTailorAsyncClientBuilder.standard();
    }

    AWSMediaTailorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaTailorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ConfigureLogsForPlaybackConfigurationResult> configureLogsForPlaybackConfigurationAsync(ConfigureLogsForPlaybackConfigurationRequest request) {
        return this.configureLogsForPlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<ConfigureLogsForPlaybackConfigurationResult> configureLogsForPlaybackConfigurationAsync(ConfigureLogsForPlaybackConfigurationRequest request, final AsyncHandler<ConfigureLogsForPlaybackConfigurationRequest, ConfigureLogsForPlaybackConfigurationResult> asyncHandler) {
        final ConfigureLogsForPlaybackConfigurationRequest finalRequest = (ConfigureLogsForPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ConfigureLogsForPlaybackConfigurationResult>(){

            @Override
            public ConfigureLogsForPlaybackConfigurationResult call() throws Exception {
                ConfigureLogsForPlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeConfigureLogsForPlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProgramResult> createProgramAsync(CreateProgramRequest request) {
        return this.createProgramAsync(request, null);
    }

    @Override
    public Future<CreateProgramResult> createProgramAsync(CreateProgramRequest request, final AsyncHandler<CreateProgramRequest, CreateProgramResult> asyncHandler) {
        final CreateProgramRequest finalRequest = (CreateProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProgramResult>(){

            @Override
            public CreateProgramResult call() throws Exception {
                CreateProgramResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeCreateProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSourceLocationResult> createSourceLocationAsync(CreateSourceLocationRequest request) {
        return this.createSourceLocationAsync(request, null);
    }

    @Override
    public Future<CreateSourceLocationResult> createSourceLocationAsync(CreateSourceLocationRequest request, final AsyncHandler<CreateSourceLocationRequest, CreateSourceLocationResult> asyncHandler) {
        final CreateSourceLocationRequest finalRequest = (CreateSourceLocationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSourceLocationResult>(){

            @Override
            public CreateSourceLocationResult call() throws Exception {
                CreateSourceLocationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeCreateSourceLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVodSourceResult> createVodSourceAsync(CreateVodSourceRequest request) {
        return this.createVodSourceAsync(request, null);
    }

    @Override
    public Future<CreateVodSourceResult> createVodSourceAsync(CreateVodSourceRequest request, final AsyncHandler<CreateVodSourceRequest, CreateVodSourceResult> asyncHandler) {
        final CreateVodSourceRequest finalRequest = (CreateVodSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVodSourceResult>(){

            @Override
            public CreateVodSourceResult call() throws Exception {
                CreateVodSourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeCreateVodSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelPolicyResult> deleteChannelPolicyAsync(DeleteChannelPolicyRequest request) {
        return this.deleteChannelPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteChannelPolicyResult> deleteChannelPolicyAsync(DeleteChannelPolicyRequest request, final AsyncHandler<DeleteChannelPolicyRequest, DeleteChannelPolicyResult> asyncHandler) {
        final DeleteChannelPolicyRequest finalRequest = (DeleteChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelPolicyResult>(){

            @Override
            public DeleteChannelPolicyResult call() throws Exception {
                DeleteChannelPolicyResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeleteChannelPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePlaybackConfigurationResult> deletePlaybackConfigurationAsync(DeletePlaybackConfigurationRequest request) {
        return this.deletePlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<DeletePlaybackConfigurationResult> deletePlaybackConfigurationAsync(DeletePlaybackConfigurationRequest request, final AsyncHandler<DeletePlaybackConfigurationRequest, DeletePlaybackConfigurationResult> asyncHandler) {
        final DeletePlaybackConfigurationRequest finalRequest = (DeletePlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePlaybackConfigurationResult>(){

            @Override
            public DeletePlaybackConfigurationResult call() throws Exception {
                DeletePlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeletePlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProgramResult> deleteProgramAsync(DeleteProgramRequest request) {
        return this.deleteProgramAsync(request, null);
    }

    @Override
    public Future<DeleteProgramResult> deleteProgramAsync(DeleteProgramRequest request, final AsyncHandler<DeleteProgramRequest, DeleteProgramResult> asyncHandler) {
        final DeleteProgramRequest finalRequest = (DeleteProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProgramResult>(){

            @Override
            public DeleteProgramResult call() throws Exception {
                DeleteProgramResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeleteProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSourceLocationResult> deleteSourceLocationAsync(DeleteSourceLocationRequest request) {
        return this.deleteSourceLocationAsync(request, null);
    }

    @Override
    public Future<DeleteSourceLocationResult> deleteSourceLocationAsync(DeleteSourceLocationRequest request, final AsyncHandler<DeleteSourceLocationRequest, DeleteSourceLocationResult> asyncHandler) {
        final DeleteSourceLocationRequest finalRequest = (DeleteSourceLocationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSourceLocationResult>(){

            @Override
            public DeleteSourceLocationResult call() throws Exception {
                DeleteSourceLocationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeleteSourceLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVodSourceResult> deleteVodSourceAsync(DeleteVodSourceRequest request) {
        return this.deleteVodSourceAsync(request, null);
    }

    @Override
    public Future<DeleteVodSourceResult> deleteVodSourceAsync(DeleteVodSourceRequest request, final AsyncHandler<DeleteVodSourceRequest, DeleteVodSourceResult> asyncHandler) {
        final DeleteVodSourceRequest finalRequest = (DeleteVodSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVodSourceResult>(){

            @Override
            public DeleteVodSourceResult call() throws Exception {
                DeleteVodSourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeleteVodSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request) {
        return this.describeChannelAsync(request, null);
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request, final AsyncHandler<DescribeChannelRequest, DescribeChannelResult> asyncHandler) {
        final DescribeChannelRequest finalRequest = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChannelResult>(){

            @Override
            public DescribeChannelResult call() throws Exception {
                DescribeChannelResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDescribeChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProgramResult> describeProgramAsync(DescribeProgramRequest request) {
        return this.describeProgramAsync(request, null);
    }

    @Override
    public Future<DescribeProgramResult> describeProgramAsync(DescribeProgramRequest request, final AsyncHandler<DescribeProgramRequest, DescribeProgramResult> asyncHandler) {
        final DescribeProgramRequest finalRequest = (DescribeProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProgramResult>(){

            @Override
            public DescribeProgramResult call() throws Exception {
                DescribeProgramResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDescribeProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSourceLocationResult> describeSourceLocationAsync(DescribeSourceLocationRequest request) {
        return this.describeSourceLocationAsync(request, null);
    }

    @Override
    public Future<DescribeSourceLocationResult> describeSourceLocationAsync(DescribeSourceLocationRequest request, final AsyncHandler<DescribeSourceLocationRequest, DescribeSourceLocationResult> asyncHandler) {
        final DescribeSourceLocationRequest finalRequest = (DescribeSourceLocationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSourceLocationResult>(){

            @Override
            public DescribeSourceLocationResult call() throws Exception {
                DescribeSourceLocationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDescribeSourceLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVodSourceResult> describeVodSourceAsync(DescribeVodSourceRequest request) {
        return this.describeVodSourceAsync(request, null);
    }

    @Override
    public Future<DescribeVodSourceResult> describeVodSourceAsync(DescribeVodSourceRequest request, final AsyncHandler<DescribeVodSourceRequest, DescribeVodSourceResult> asyncHandler) {
        final DescribeVodSourceRequest finalRequest = (DescribeVodSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVodSourceResult>(){

            @Override
            public DescribeVodSourceResult call() throws Exception {
                DescribeVodSourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDescribeVodSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChannelPolicyResult> getChannelPolicyAsync(GetChannelPolicyRequest request) {
        return this.getChannelPolicyAsync(request, null);
    }

    @Override
    public Future<GetChannelPolicyResult> getChannelPolicyAsync(GetChannelPolicyRequest request, final AsyncHandler<GetChannelPolicyRequest, GetChannelPolicyResult> asyncHandler) {
        final GetChannelPolicyRequest finalRequest = (GetChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChannelPolicyResult>(){

            @Override
            public GetChannelPolicyResult call() throws Exception {
                GetChannelPolicyResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeGetChannelPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChannelScheduleResult> getChannelScheduleAsync(GetChannelScheduleRequest request) {
        return this.getChannelScheduleAsync(request, null);
    }

    @Override
    public Future<GetChannelScheduleResult> getChannelScheduleAsync(GetChannelScheduleRequest request, final AsyncHandler<GetChannelScheduleRequest, GetChannelScheduleResult> asyncHandler) {
        final GetChannelScheduleRequest finalRequest = (GetChannelScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChannelScheduleResult>(){

            @Override
            public GetChannelScheduleResult call() throws Exception {
                GetChannelScheduleResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeGetChannelSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPlaybackConfigurationResult> getPlaybackConfigurationAsync(GetPlaybackConfigurationRequest request) {
        return this.getPlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<GetPlaybackConfigurationResult> getPlaybackConfigurationAsync(GetPlaybackConfigurationRequest request, final AsyncHandler<GetPlaybackConfigurationRequest, GetPlaybackConfigurationResult> asyncHandler) {
        final GetPlaybackConfigurationRequest finalRequest = (GetPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPlaybackConfigurationResult>(){

            @Override
            public GetPlaybackConfigurationResult call() throws Exception {
                GetPlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeGetPlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAlertsResult> listAlertsAsync(ListAlertsRequest request) {
        return this.listAlertsAsync(request, null);
    }

    @Override
    public Future<ListAlertsResult> listAlertsAsync(ListAlertsRequest request, final AsyncHandler<ListAlertsRequest, ListAlertsResult> asyncHandler) {
        final ListAlertsRequest finalRequest = (ListAlertsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAlertsResult>(){

            @Override
            public ListAlertsResult call() throws Exception {
                ListAlertsResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListAlerts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlaybackConfigurationsResult> listPlaybackConfigurationsAsync(ListPlaybackConfigurationsRequest request) {
        return this.listPlaybackConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListPlaybackConfigurationsResult> listPlaybackConfigurationsAsync(ListPlaybackConfigurationsRequest request, final AsyncHandler<ListPlaybackConfigurationsRequest, ListPlaybackConfigurationsResult> asyncHandler) {
        final ListPlaybackConfigurationsRequest finalRequest = (ListPlaybackConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPlaybackConfigurationsResult>(){

            @Override
            public ListPlaybackConfigurationsResult call() throws Exception {
                ListPlaybackConfigurationsResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListPlaybackConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSourceLocationsResult> listSourceLocationsAsync(ListSourceLocationsRequest request) {
        return this.listSourceLocationsAsync(request, null);
    }

    @Override
    public Future<ListSourceLocationsResult> listSourceLocationsAsync(ListSourceLocationsRequest request, final AsyncHandler<ListSourceLocationsRequest, ListSourceLocationsResult> asyncHandler) {
        final ListSourceLocationsRequest finalRequest = (ListSourceLocationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSourceLocationsResult>(){

            @Override
            public ListSourceLocationsResult call() throws Exception {
                ListSourceLocationsResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListSourceLocations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVodSourcesResult> listVodSourcesAsync(ListVodSourcesRequest request) {
        return this.listVodSourcesAsync(request, null);
    }

    @Override
    public Future<ListVodSourcesResult> listVodSourcesAsync(ListVodSourcesRequest request, final AsyncHandler<ListVodSourcesRequest, ListVodSourcesResult> asyncHandler) {
        final ListVodSourcesRequest finalRequest = (ListVodSourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVodSourcesResult>(){

            @Override
            public ListVodSourcesResult call() throws Exception {
                ListVodSourcesResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListVodSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutChannelPolicyResult> putChannelPolicyAsync(PutChannelPolicyRequest request) {
        return this.putChannelPolicyAsync(request, null);
    }

    @Override
    public Future<PutChannelPolicyResult> putChannelPolicyAsync(PutChannelPolicyRequest request, final AsyncHandler<PutChannelPolicyRequest, PutChannelPolicyResult> asyncHandler) {
        final PutChannelPolicyRequest finalRequest = (PutChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutChannelPolicyResult>(){

            @Override
            public PutChannelPolicyResult call() throws Exception {
                PutChannelPolicyResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executePutChannelPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPlaybackConfigurationResult> putPlaybackConfigurationAsync(PutPlaybackConfigurationRequest request) {
        return this.putPlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<PutPlaybackConfigurationResult> putPlaybackConfigurationAsync(PutPlaybackConfigurationRequest request, final AsyncHandler<PutPlaybackConfigurationRequest, PutPlaybackConfigurationResult> asyncHandler) {
        final PutPlaybackConfigurationRequest finalRequest = (PutPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPlaybackConfigurationResult>(){

            @Override
            public PutPlaybackConfigurationResult call() throws Exception {
                PutPlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executePutPlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartChannelResult> startChannelAsync(StartChannelRequest request) {
        return this.startChannelAsync(request, null);
    }

    @Override
    public Future<StartChannelResult> startChannelAsync(StartChannelRequest request, final AsyncHandler<StartChannelRequest, StartChannelResult> asyncHandler) {
        final StartChannelRequest finalRequest = (StartChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartChannelResult>(){

            @Override
            public StartChannelResult call() throws Exception {
                StartChannelResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeStartChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopChannelResult> stopChannelAsync(StopChannelRequest request) {
        return this.stopChannelAsync(request, null);
    }

    @Override
    public Future<StopChannelResult> stopChannelAsync(StopChannelRequest request, final AsyncHandler<StopChannelRequest, StopChannelResult> asyncHandler) {
        final StopChannelRequest finalRequest = (StopChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopChannelResult>(){

            @Override
            public StopChannelResult call() throws Exception {
                StopChannelResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeStopChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSourceLocationResult> updateSourceLocationAsync(UpdateSourceLocationRequest request) {
        return this.updateSourceLocationAsync(request, null);
    }

    @Override
    public Future<UpdateSourceLocationResult> updateSourceLocationAsync(UpdateSourceLocationRequest request, final AsyncHandler<UpdateSourceLocationRequest, UpdateSourceLocationResult> asyncHandler) {
        final UpdateSourceLocationRequest finalRequest = (UpdateSourceLocationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSourceLocationResult>(){

            @Override
            public UpdateSourceLocationResult call() throws Exception {
                UpdateSourceLocationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeUpdateSourceLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVodSourceResult> updateVodSourceAsync(UpdateVodSourceRequest request) {
        return this.updateVodSourceAsync(request, null);
    }

    @Override
    public Future<UpdateVodSourceResult> updateVodSourceAsync(UpdateVodSourceRequest request, final AsyncHandler<UpdateVodSourceRequest, UpdateVodSourceResult> asyncHandler) {
        final UpdateVodSourceRequest finalRequest = (UpdateVodSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVodSourceResult>(){

            @Override
            public UpdateVodSourceResult call() throws Exception {
                UpdateVodSourceResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeUpdateVodSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

