/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediatailor.model.LogConfigurationForChannel;
import com.amazonaws.services.mediatailor.model.ResponseOutputItem;
import com.amazonaws.services.mediatailor.model.SlateSource;
import com.amazonaws.services.mediatailor.model.transform.ChannelMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Channel
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String channelName;
    private String channelState;
    private Date creationTime;
    private SlateSource fillerSlate;
    private Date lastModifiedTime;
    private LogConfigurationForChannel logConfiguration;
    private List<ResponseOutputItem> outputs;
    private String playbackMode;
    private Map<String, String> tags;
    private String tier;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Channel withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Channel withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public void setChannelState(String channelState) {
        this.channelState = channelState;
    }

    public String getChannelState() {
        return this.channelState;
    }

    public Channel withChannelState(String channelState) {
        this.setChannelState(channelState);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Channel withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setFillerSlate(SlateSource fillerSlate) {
        this.fillerSlate = fillerSlate;
    }

    public SlateSource getFillerSlate() {
        return this.fillerSlate;
    }

    public Channel withFillerSlate(SlateSource fillerSlate) {
        this.setFillerSlate(fillerSlate);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Channel withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setLogConfiguration(LogConfigurationForChannel logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public LogConfigurationForChannel getLogConfiguration() {
        return this.logConfiguration;
    }

    public Channel withLogConfiguration(LogConfigurationForChannel logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public List<ResponseOutputItem> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<ResponseOutputItem> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<ResponseOutputItem>(outputs);
    }

    public Channel withOutputs(ResponseOutputItem ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<ResponseOutputItem>(outputs.length));
        }
        for (ResponseOutputItem ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public Channel withOutputs(Collection<ResponseOutputItem> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setPlaybackMode(String playbackMode) {
        this.playbackMode = playbackMode;
    }

    public String getPlaybackMode() {
        return this.playbackMode;
    }

    public Channel withPlaybackMode(String playbackMode) {
        this.setPlaybackMode(playbackMode);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Channel withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Channel addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Channel clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public Channel withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getChannelState() != null) {
            sb.append("ChannelState: ").append(this.getChannelState()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getFillerSlate() != null) {
            sb.append("FillerSlate: ").append(this.getFillerSlate()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getPlaybackMode() != null) {
            sb.append("PlaybackMode: ").append(this.getPlaybackMode()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getChannelState() == null ^ this.getChannelState() == null) {
            return false;
        }
        if (other.getChannelState() != null && !other.getChannelState().equals(this.getChannelState())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getFillerSlate() == null ^ this.getFillerSlate() == null) {
            return false;
        }
        if (other.getFillerSlate() != null && !other.getFillerSlate().equals(this.getFillerSlate())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        if (other.getLogConfiguration() != null && !other.getLogConfiguration().equals(this.getLogConfiguration())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getPlaybackMode() == null ^ this.getPlaybackMode() == null) {
            return false;
        }
        if (other.getPlaybackMode() != null && !other.getPlaybackMode().equals(this.getPlaybackMode())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        return other.getTier() == null || other.getTier().equals(this.getTier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getChannelState() == null ? 0 : this.getChannelState().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFillerSlate() == null ? 0 : this.getFillerSlate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getPlaybackMode() == null ? 0 : this.getPlaybackMode().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        return hashCode;
    }

    public Channel clone() {
        try {
            return (Channel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

