/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediatailor.model.AlertCategory;
import com.amazonaws.services.mediatailor.model.transform.AlertMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Alert
implements Serializable,
Cloneable,
StructuredPojo {
    private String alertCode;
    private String alertMessage;
    private String category;
    private Date lastModifiedTime;
    private List<String> relatedResourceArns;
    private String resourceArn;

    public void setAlertCode(String alertCode) {
        this.alertCode = alertCode;
    }

    public String getAlertCode() {
        return this.alertCode;
    }

    public Alert withAlertCode(String alertCode) {
        this.setAlertCode(alertCode);
        return this;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public Alert withAlertMessage(String alertMessage) {
        this.setAlertMessage(alertMessage);
        return this;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public Alert withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public Alert withCategory(AlertCategory category) {
        this.category = category.toString();
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Alert withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<String> getRelatedResourceArns() {
        return this.relatedResourceArns;
    }

    public void setRelatedResourceArns(Collection<String> relatedResourceArns) {
        if (relatedResourceArns == null) {
            this.relatedResourceArns = null;
            return;
        }
        this.relatedResourceArns = new ArrayList<String>(relatedResourceArns);
    }

    public Alert withRelatedResourceArns(String ... relatedResourceArns) {
        if (this.relatedResourceArns == null) {
            this.setRelatedResourceArns(new ArrayList<String>(relatedResourceArns.length));
        }
        for (String ele : relatedResourceArns) {
            this.relatedResourceArns.add(ele);
        }
        return this;
    }

    public Alert withRelatedResourceArns(Collection<String> relatedResourceArns) {
        this.setRelatedResourceArns(relatedResourceArns);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public Alert withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlertCode() != null) {
            sb.append("AlertCode: ").append(this.getAlertCode()).append(",");
        }
        if (this.getAlertMessage() != null) {
            sb.append("AlertMessage: ").append(this.getAlertMessage()).append(",");
        }
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getRelatedResourceArns() != null) {
            sb.append("RelatedResourceArns: ").append(this.getRelatedResourceArns()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)obj;
        if (other.getAlertCode() == null ^ this.getAlertCode() == null) {
            return false;
        }
        if (other.getAlertCode() != null && !other.getAlertCode().equals(this.getAlertCode())) {
            return false;
        }
        if (other.getAlertMessage() == null ^ this.getAlertMessage() == null) {
            return false;
        }
        if (other.getAlertMessage() != null && !other.getAlertMessage().equals(this.getAlertMessage())) {
            return false;
        }
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getRelatedResourceArns() == null ^ this.getRelatedResourceArns() == null) {
            return false;
        }
        if (other.getRelatedResourceArns() != null && !other.getRelatedResourceArns().equals(this.getRelatedResourceArns())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        return other.getResourceArn() == null || other.getResourceArn().equals(this.getResourceArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlertCode() == null ? 0 : this.getAlertCode().hashCode());
        hashCode = 31 * hashCode + (this.getAlertMessage() == null ? 0 : this.getAlertMessage().hashCode());
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedResourceArns() == null ? 0 : this.getRelatedResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        return hashCode;
    }

    public Alert clone() {
        try {
            return (Alert)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlertMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

