/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediatailor.model.LogType;
import com.amazonaws.services.mediatailor.model.transform.LogConfigurationForChannelMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogConfigurationForChannel
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> logTypes;

    public List<String> getLogTypes() {
        return this.logTypes;
    }

    public void setLogTypes(Collection<String> logTypes) {
        if (logTypes == null) {
            this.logTypes = null;
            return;
        }
        this.logTypes = new ArrayList<String>(logTypes);
    }

    public LogConfigurationForChannel withLogTypes(String ... logTypes) {
        if (this.logTypes == null) {
            this.setLogTypes(new ArrayList<String>(logTypes.length));
        }
        for (String ele : logTypes) {
            this.logTypes.add(ele);
        }
        return this;
    }

    public LogConfigurationForChannel withLogTypes(Collection<String> logTypes) {
        this.setLogTypes(logTypes);
        return this;
    }

    public LogConfigurationForChannel withLogTypes(LogType ... logTypes) {
        ArrayList<String> logTypesCopy = new ArrayList<String>(logTypes.length);
        for (LogType value : logTypes) {
            logTypesCopy.add(value.toString());
        }
        if (this.getLogTypes() == null) {
            this.setLogTypes(logTypesCopy);
        } else {
            this.getLogTypes().addAll(logTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogTypes() != null) {
            sb.append("LogTypes: ").append(this.getLogTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationForChannel)) {
            return false;
        }
        LogConfigurationForChannel other = (LogConfigurationForChannel)obj;
        if (other.getLogTypes() == null ^ this.getLogTypes() == null) {
            return false;
        }
        return other.getLogTypes() == null || other.getLogTypes().equals(this.getLogTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogTypes() == null ? 0 : this.getLogTypes().hashCode());
        return hashCode;
    }

    public LogConfigurationForChannel clone() {
        try {
            return (LogConfigurationForChannel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogConfigurationForChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

