/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediatailor.model.HttpPackageConfiguration;
import com.amazonaws.services.mediatailor.model.transform.LiveSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LiveSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date creationTime;
    private List<HttpPackageConfiguration> httpPackageConfigurations;
    private Date lastModifiedTime;
    private String liveSourceName;
    private String sourceLocationName;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public LiveSource withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public LiveSource withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<HttpPackageConfiguration> getHttpPackageConfigurations() {
        return this.httpPackageConfigurations;
    }

    public void setHttpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        if (httpPackageConfigurations == null) {
            this.httpPackageConfigurations = null;
            return;
        }
        this.httpPackageConfigurations = new ArrayList<HttpPackageConfiguration>(httpPackageConfigurations);
    }

    public LiveSource withHttpPackageConfigurations(HttpPackageConfiguration ... httpPackageConfigurations) {
        if (this.httpPackageConfigurations == null) {
            this.setHttpPackageConfigurations(new ArrayList<HttpPackageConfiguration>(httpPackageConfigurations.length));
        }
        for (HttpPackageConfiguration ele : httpPackageConfigurations) {
            this.httpPackageConfigurations.add(ele);
        }
        return this;
    }

    public LiveSource withHttpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        this.setHttpPackageConfigurations(httpPackageConfigurations);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LiveSource withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setLiveSourceName(String liveSourceName) {
        this.liveSourceName = liveSourceName;
    }

    public String getLiveSourceName() {
        return this.liveSourceName;
    }

    public LiveSource withLiveSourceName(String liveSourceName) {
        this.setLiveSourceName(liveSourceName);
        return this;
    }

    public void setSourceLocationName(String sourceLocationName) {
        this.sourceLocationName = sourceLocationName;
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public LiveSource withSourceLocationName(String sourceLocationName) {
        this.setSourceLocationName(sourceLocationName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public LiveSource withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public LiveSource addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public LiveSource clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getHttpPackageConfigurations() != null) {
            sb.append("HttpPackageConfigurations: ").append(this.getHttpPackageConfigurations()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getLiveSourceName() != null) {
            sb.append("LiveSourceName: ").append(this.getLiveSourceName()).append(",");
        }
        if (this.getSourceLocationName() != null) {
            sb.append("SourceLocationName: ").append(this.getSourceLocationName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveSource)) {
            return false;
        }
        LiveSource other = (LiveSource)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getHttpPackageConfigurations() == null ^ this.getHttpPackageConfigurations() == null) {
            return false;
        }
        if (other.getHttpPackageConfigurations() != null && !other.getHttpPackageConfigurations().equals(this.getHttpPackageConfigurations())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getLiveSourceName() == null ^ this.getLiveSourceName() == null) {
            return false;
        }
        if (other.getLiveSourceName() != null && !other.getLiveSourceName().equals(this.getLiveSourceName())) {
            return false;
        }
        if (other.getSourceLocationName() == null ^ this.getSourceLocationName() == null) {
            return false;
        }
        if (other.getSourceLocationName() != null && !other.getSourceLocationName().equals(this.getSourceLocationName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getHttpPackageConfigurations() == null ? 0 : this.getHttpPackageConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLiveSourceName() == null ? 0 : this.getLiveSourceName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLocationName() == null ? 0 : this.getSourceLocationName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public LiveSource clone() {
        try {
            return (LiveSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LiveSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

