/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediatailor.model.HttpPackageConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateLiveSourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<HttpPackageConfiguration> httpPackageConfigurations;
    private String liveSourceName;
    private String sourceLocationName;

    public List<HttpPackageConfiguration> getHttpPackageConfigurations() {
        return this.httpPackageConfigurations;
    }

    public void setHttpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        if (httpPackageConfigurations == null) {
            this.httpPackageConfigurations = null;
            return;
        }
        this.httpPackageConfigurations = new ArrayList<HttpPackageConfiguration>(httpPackageConfigurations);
    }

    public UpdateLiveSourceRequest withHttpPackageConfigurations(HttpPackageConfiguration ... httpPackageConfigurations) {
        if (this.httpPackageConfigurations == null) {
            this.setHttpPackageConfigurations(new ArrayList<HttpPackageConfiguration>(httpPackageConfigurations.length));
        }
        for (HttpPackageConfiguration ele : httpPackageConfigurations) {
            this.httpPackageConfigurations.add(ele);
        }
        return this;
    }

    public UpdateLiveSourceRequest withHttpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        this.setHttpPackageConfigurations(httpPackageConfigurations);
        return this;
    }

    public void setLiveSourceName(String liveSourceName) {
        this.liveSourceName = liveSourceName;
    }

    public String getLiveSourceName() {
        return this.liveSourceName;
    }

    public UpdateLiveSourceRequest withLiveSourceName(String liveSourceName) {
        this.setLiveSourceName(liveSourceName);
        return this;
    }

    public void setSourceLocationName(String sourceLocationName) {
        this.sourceLocationName = sourceLocationName;
    }

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    public UpdateLiveSourceRequest withSourceLocationName(String sourceLocationName) {
        this.setSourceLocationName(sourceLocationName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHttpPackageConfigurations() != null) {
            sb.append("HttpPackageConfigurations: ").append(this.getHttpPackageConfigurations()).append(",");
        }
        if (this.getLiveSourceName() != null) {
            sb.append("LiveSourceName: ").append(this.getLiveSourceName()).append(",");
        }
        if (this.getSourceLocationName() != null) {
            sb.append("SourceLocationName: ").append(this.getSourceLocationName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLiveSourceRequest)) {
            return false;
        }
        UpdateLiveSourceRequest other = (UpdateLiveSourceRequest)obj;
        if (other.getHttpPackageConfigurations() == null ^ this.getHttpPackageConfigurations() == null) {
            return false;
        }
        if (other.getHttpPackageConfigurations() != null && !other.getHttpPackageConfigurations().equals(this.getHttpPackageConfigurations())) {
            return false;
        }
        if (other.getLiveSourceName() == null ^ this.getLiveSourceName() == null) {
            return false;
        }
        if (other.getLiveSourceName() != null && !other.getLiveSourceName().equals(this.getLiveSourceName())) {
            return false;
        }
        if (other.getSourceLocationName() == null ^ this.getSourceLocationName() == null) {
            return false;
        }
        return other.getSourceLocationName() == null || other.getSourceLocationName().equals(this.getSourceLocationName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHttpPackageConfigurations() == null ? 0 : this.getHttpPackageConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getLiveSourceName() == null ? 0 : this.getLiveSourceName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLocationName() == null ? 0 : this.getSourceLocationName().hashCode());
        return hashCode;
    }

    public UpdateLiveSourceRequest clone() {
        return (UpdateLiveSourceRequest)super.clone();
    }
}

