/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagevod.model.HlsEncryption;
import com.amazonaws.services.mediapackagevod.model.HlsManifest;
import com.amazonaws.services.mediapackagevod.model.transform.HlsPackageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HlsPackage
implements Serializable,
Cloneable,
StructuredPojo {
    private HlsEncryption encryption;
    private List<HlsManifest> hlsManifests;
    private Boolean includeDvbSubtitles;
    private Integer segmentDurationSeconds;
    private Boolean useAudioRenditionGroup;

    public void setEncryption(HlsEncryption encryption) {
        this.encryption = encryption;
    }

    public HlsEncryption getEncryption() {
        return this.encryption;
    }

    public HlsPackage withEncryption(HlsEncryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public List<HlsManifest> getHlsManifests() {
        return this.hlsManifests;
    }

    public void setHlsManifests(Collection<HlsManifest> hlsManifests) {
        if (hlsManifests == null) {
            this.hlsManifests = null;
            return;
        }
        this.hlsManifests = new ArrayList<HlsManifest>(hlsManifests);
    }

    public HlsPackage withHlsManifests(HlsManifest ... hlsManifests) {
        if (this.hlsManifests == null) {
            this.setHlsManifests(new ArrayList<HlsManifest>(hlsManifests.length));
        }
        for (HlsManifest ele : hlsManifests) {
            this.hlsManifests.add(ele);
        }
        return this;
    }

    public HlsPackage withHlsManifests(Collection<HlsManifest> hlsManifests) {
        this.setHlsManifests(hlsManifests);
        return this;
    }

    public void setIncludeDvbSubtitles(Boolean includeDvbSubtitles) {
        this.includeDvbSubtitles = includeDvbSubtitles;
    }

    public Boolean getIncludeDvbSubtitles() {
        return this.includeDvbSubtitles;
    }

    public HlsPackage withIncludeDvbSubtitles(Boolean includeDvbSubtitles) {
        this.setIncludeDvbSubtitles(includeDvbSubtitles);
        return this;
    }

    public Boolean isIncludeDvbSubtitles() {
        return this.includeDvbSubtitles;
    }

    public void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.segmentDurationSeconds = segmentDurationSeconds;
    }

    public Integer getSegmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public HlsPackage withSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.setSegmentDurationSeconds(segmentDurationSeconds);
        return this;
    }

    public void setUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
        this.useAudioRenditionGroup = useAudioRenditionGroup;
    }

    public Boolean getUseAudioRenditionGroup() {
        return this.useAudioRenditionGroup;
    }

    public HlsPackage withUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
        this.setUseAudioRenditionGroup(useAudioRenditionGroup);
        return this;
    }

    public Boolean isUseAudioRenditionGroup() {
        return this.useAudioRenditionGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getHlsManifests() != null) {
            sb.append("HlsManifests: ").append(this.getHlsManifests()).append(",");
        }
        if (this.getIncludeDvbSubtitles() != null) {
            sb.append("IncludeDvbSubtitles: ").append(this.getIncludeDvbSubtitles()).append(",");
        }
        if (this.getSegmentDurationSeconds() != null) {
            sb.append("SegmentDurationSeconds: ").append(this.getSegmentDurationSeconds()).append(",");
        }
        if (this.getUseAudioRenditionGroup() != null) {
            sb.append("UseAudioRenditionGroup: ").append(this.getUseAudioRenditionGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPackage)) {
            return false;
        }
        HlsPackage other = (HlsPackage)obj;
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getHlsManifests() == null ^ this.getHlsManifests() == null) {
            return false;
        }
        if (other.getHlsManifests() != null && !other.getHlsManifests().equals(this.getHlsManifests())) {
            return false;
        }
        if (other.getIncludeDvbSubtitles() == null ^ this.getIncludeDvbSubtitles() == null) {
            return false;
        }
        if (other.getIncludeDvbSubtitles() != null && !other.getIncludeDvbSubtitles().equals(this.getIncludeDvbSubtitles())) {
            return false;
        }
        if (other.getSegmentDurationSeconds() == null ^ this.getSegmentDurationSeconds() == null) {
            return false;
        }
        if (other.getSegmentDurationSeconds() != null && !other.getSegmentDurationSeconds().equals(this.getSegmentDurationSeconds())) {
            return false;
        }
        if (other.getUseAudioRenditionGroup() == null ^ this.getUseAudioRenditionGroup() == null) {
            return false;
        }
        return other.getUseAudioRenditionGroup() == null || other.getUseAudioRenditionGroup().equals(this.getUseAudioRenditionGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getHlsManifests() == null ? 0 : this.getHlsManifests().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeDvbSubtitles() == null ? 0 : this.getIncludeDvbSubtitles().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentDurationSeconds() == null ? 0 : this.getSegmentDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getUseAudioRenditionGroup() == null ? 0 : this.getUseAudioRenditionGroup().hashCode());
        return hashCode;
    }

    public HlsPackage clone() {
        try {
            return (HlsPackage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

