/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagev2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagev2.model.Encryption;

@SdkInternalApi
public class EncryptionMarshaller {
    private static final MarshallingInfo<String> CONSTANTINITIALIZATIONVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConstantInitializationVector").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionMethod").build();
    private static final MarshallingInfo<Integer> KEYROTATIONINTERVALSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyRotationIntervalSeconds").build();
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpekeKeyProvider").build();
    private static final EncryptionMarshaller instance = new EncryptionMarshaller();

    public static EncryptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Encryption encryption, ProtocolMarshaller protocolMarshaller) {
        if (encryption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)encryption.getConstantInitializationVector(), CONSTANTINITIALIZATIONVECTOR_BINDING);
            protocolMarshaller.marshall((Object)encryption.getEncryptionMethod(), ENCRYPTIONMETHOD_BINDING);
            protocolMarshaller.marshall((Object)encryption.getKeyRotationIntervalSeconds(), KEYROTATIONINTERVALSECONDS_BINDING);
            protocolMarshaller.marshall((Object)encryption.getSpekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

