/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.MediaResourceNeighbor;
import com.amazonaws.services.medialive.model.transform.MediaResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MediaResource
implements Serializable,
Cloneable,
StructuredPojo {
    private List<MediaResourceNeighbor> destinations;
    private String name;
    private List<MediaResourceNeighbor> sources;

    public List<MediaResourceNeighbor> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<MediaResourceNeighbor> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<MediaResourceNeighbor>(destinations);
    }

    public MediaResource withDestinations(MediaResourceNeighbor ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<MediaResourceNeighbor>(destinations.length));
        }
        for (MediaResourceNeighbor ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public MediaResource withDestinations(Collection<MediaResourceNeighbor> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MediaResource withName(String name) {
        this.setName(name);
        return this;
    }

    public List<MediaResourceNeighbor> getSources() {
        return this.sources;
    }

    public void setSources(Collection<MediaResourceNeighbor> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<MediaResourceNeighbor>(sources);
    }

    public MediaResource withSources(MediaResourceNeighbor ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<MediaResourceNeighbor>(sources.length));
        }
        for (MediaResourceNeighbor ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public MediaResource withSources(Collection<MediaResourceNeighbor> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaResource)) {
            return false;
        }
        MediaResource other = (MediaResource)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public MediaResource clone() {
        try {
            return (MediaResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MediaResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

