/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.EncoderSettings;
import java.util.List;

@SdkInternalApi
public class EncoderSettingsMarshaller {
    private static final MarshallingInfo<List> AUDIODESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDescriptions").build();
    private static final MarshallingInfo<StructuredPojo> AVAILBLANKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availBlanking").build();
    private static final MarshallingInfo<StructuredPojo> AVAILCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> BLACKOUTSLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blackoutSlate").build();
    private static final MarshallingInfo<List> CAPTIONDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionDescriptions").build();
    private static final MarshallingInfo<StructuredPojo> FEATUREACTIVATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("featureActivations").build();
    private static final MarshallingInfo<StructuredPojo> GLOBALCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("globalConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> MOTIONGRAPHICSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("motionGraphicsConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> NIELSENCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nielsenConfiguration").build();
    private static final MarshallingInfo<List> OUTPUTGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputGroups").build();
    private static final MarshallingInfo<StructuredPojo> TIMECODECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeConfig").build();
    private static final MarshallingInfo<List> VIDEODESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoDescriptions").build();
    private static final MarshallingInfo<StructuredPojo> THUMBNAILCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thumbnailConfiguration").build();
    private static final EncoderSettingsMarshaller instance = new EncoderSettingsMarshaller();

    public static EncoderSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(EncoderSettings encoderSettings, ProtocolMarshaller protocolMarshaller) {
        if (encoderSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(encoderSettings.getAudioDescriptions(), AUDIODESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getAvailBlanking(), AVAILBLANKING_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getAvailConfiguration(), AVAILCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getBlackoutSlate(), BLACKOUTSLATE_BINDING);
            protocolMarshaller.marshall(encoderSettings.getCaptionDescriptions(), CAPTIONDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getFeatureActivations(), FEATUREACTIVATIONS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getGlobalConfiguration(), GLOBALCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getMotionGraphicsConfiguration(), MOTIONGRAPHICSCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getNielsenConfiguration(), NIELSENCONFIGURATION_BINDING);
            protocolMarshaller.marshall(encoderSettings.getOutputGroups(), OUTPUTGROUPS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getTimecodeConfig(), TIMECODECONFIG_BINDING);
            protocolMarshaller.marshall(encoderSettings.getVideoDescriptions(), VIDEODESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.getThumbnailConfiguration(), THUMBNAILCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

