/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.HlsInputSettings;

@SdkInternalApi
public class HlsInputSettingsMarshaller {
    private static final MarshallingInfo<Integer> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").build();
    private static final MarshallingInfo<Integer> BUFFERSEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufferSegments").build();
    private static final MarshallingInfo<Integer> RETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retries").build();
    private static final MarshallingInfo<Integer> RETRYINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryInterval").build();
    private static final MarshallingInfo<String> SCTE35SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Source").build();
    private static final HlsInputSettingsMarshaller instance = new HlsInputSettingsMarshaller();

    public static HlsInputSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(HlsInputSettings hlsInputSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsInputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hlsInputSettings.getBandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.getBufferSegments(), BUFFERSEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.getRetries(), RETRIES_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.getRetryInterval(), RETRYINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.getScte35Source(), SCTE35SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

