/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.WavCodingMode;
import com.amazonaws.services.medialive.model.transform.WavSettingsMarshaller;
import java.io.Serializable;

public class WavSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Double bitDepth;
    private String codingMode;
    private Double sampleRate;

    public void setBitDepth(Double bitDepth) {
        this.bitDepth = bitDepth;
    }

    public Double getBitDepth() {
        return this.bitDepth;
    }

    public WavSettings withBitDepth(Double bitDepth) {
        this.setBitDepth(bitDepth);
        return this;
    }

    public void setCodingMode(String codingMode) {
        this.codingMode = codingMode;
    }

    public String getCodingMode() {
        return this.codingMode;
    }

    public WavSettings withCodingMode(String codingMode) {
        this.setCodingMode(codingMode);
        return this;
    }

    public WavSettings withCodingMode(WavCodingMode codingMode) {
        this.codingMode = codingMode.toString();
        return this;
    }

    public void setSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Double getSampleRate() {
        return this.sampleRate;
    }

    public WavSettings withSampleRate(Double sampleRate) {
        this.setSampleRate(sampleRate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBitDepth() != null) {
            sb.append("BitDepth: ").append(this.getBitDepth()).append(",");
        }
        if (this.getCodingMode() != null) {
            sb.append("CodingMode: ").append(this.getCodingMode()).append(",");
        }
        if (this.getSampleRate() != null) {
            sb.append("SampleRate: ").append(this.getSampleRate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WavSettings)) {
            return false;
        }
        WavSettings other = (WavSettings)obj;
        if (other.getBitDepth() == null ^ this.getBitDepth() == null) {
            return false;
        }
        if (other.getBitDepth() != null && !other.getBitDepth().equals(this.getBitDepth())) {
            return false;
        }
        if (other.getCodingMode() == null ^ this.getCodingMode() == null) {
            return false;
        }
        if (other.getCodingMode() != null && !other.getCodingMode().equals(this.getCodingMode())) {
            return false;
        }
        if (other.getSampleRate() == null ^ this.getSampleRate() == null) {
            return false;
        }
        return other.getSampleRate() == null || other.getSampleRate().equals(this.getSampleRate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBitDepth() == null ? 0 : this.getBitDepth().hashCode());
        hashCode = 31 * hashCode + (this.getCodingMode() == null ? 0 : this.getCodingMode().hashCode());
        hashCode = 31 * hashCode + (this.getSampleRate() == null ? 0 : this.getSampleRate().hashCode());
        return hashCode;
    }

    public WavSettings clone() {
        try {
            return (WavSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WavSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

