/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.OutputLocationRef;
import com.amazonaws.services.medialive.model.RtmpOutputCertificateMode;
import com.amazonaws.services.medialive.model.transform.RtmpOutputSettingsMarshaller;
import java.io.Serializable;

public class RtmpOutputSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String certificateMode;
    private Integer connectionRetryInterval;
    private OutputLocationRef destination;
    private Integer numRetries;

    public void setCertificateMode(String certificateMode) {
        this.certificateMode = certificateMode;
    }

    public String getCertificateMode() {
        return this.certificateMode;
    }

    public RtmpOutputSettings withCertificateMode(String certificateMode) {
        this.setCertificateMode(certificateMode);
        return this;
    }

    public RtmpOutputSettings withCertificateMode(RtmpOutputCertificateMode certificateMode) {
        this.certificateMode = certificateMode.toString();
        return this;
    }

    public void setConnectionRetryInterval(Integer connectionRetryInterval) {
        this.connectionRetryInterval = connectionRetryInterval;
    }

    public Integer getConnectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public RtmpOutputSettings withConnectionRetryInterval(Integer connectionRetryInterval) {
        this.setConnectionRetryInterval(connectionRetryInterval);
        return this;
    }

    public void setDestination(OutputLocationRef destination) {
        this.destination = destination;
    }

    public OutputLocationRef getDestination() {
        return this.destination;
    }

    public RtmpOutputSettings withDestination(OutputLocationRef destination) {
        this.setDestination(destination);
        return this;
    }

    public void setNumRetries(Integer numRetries) {
        this.numRetries = numRetries;
    }

    public Integer getNumRetries() {
        return this.numRetries;
    }

    public RtmpOutputSettings withNumRetries(Integer numRetries) {
        this.setNumRetries(numRetries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateMode() != null) {
            sb.append("CertificateMode: ").append(this.getCertificateMode()).append(",");
        }
        if (this.getConnectionRetryInterval() != null) {
            sb.append("ConnectionRetryInterval: ").append(this.getConnectionRetryInterval()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getNumRetries() != null) {
            sb.append("NumRetries: ").append(this.getNumRetries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtmpOutputSettings)) {
            return false;
        }
        RtmpOutputSettings other = (RtmpOutputSettings)obj;
        if (other.getCertificateMode() == null ^ this.getCertificateMode() == null) {
            return false;
        }
        if (other.getCertificateMode() != null && !other.getCertificateMode().equals(this.getCertificateMode())) {
            return false;
        }
        if (other.getConnectionRetryInterval() == null ^ this.getConnectionRetryInterval() == null) {
            return false;
        }
        if (other.getConnectionRetryInterval() != null && !other.getConnectionRetryInterval().equals(this.getConnectionRetryInterval())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getNumRetries() == null ^ this.getNumRetries() == null) {
            return false;
        }
        return other.getNumRetries() == null || other.getNumRetries().equals(this.getNumRetries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateMode() == null ? 0 : this.getCertificateMode().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionRetryInterval() == null ? 0 : this.getConnectionRetryInterval().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getNumRetries() == null ? 0 : this.getNumRetries().hashCode());
        return hashCode;
    }

    public RtmpOutputSettings clone() {
        try {
            return (RtmpOutputSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RtmpOutputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

