/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.medialive.model.MultiplexSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateMultiplexRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> availabilityZones;
    private MultiplexSettings multiplexSettings;
    private String name;
    private String requestId;
    private Map<String, String> tags;

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<String>(availabilityZones);
    }

    public CreateMultiplexRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public CreateMultiplexRequest withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setMultiplexSettings(MultiplexSettings multiplexSettings) {
        this.multiplexSettings = multiplexSettings;
    }

    public MultiplexSettings getMultiplexSettings() {
        return this.multiplexSettings;
    }

    public CreateMultiplexRequest withMultiplexSettings(MultiplexSettings multiplexSettings) {
        this.setMultiplexSettings(multiplexSettings);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateMultiplexRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CreateMultiplexRequest withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateMultiplexRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateMultiplexRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateMultiplexRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getMultiplexSettings() != null) {
            sb.append("MultiplexSettings: ").append(this.getMultiplexSettings()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiplexRequest)) {
            return false;
        }
        CreateMultiplexRequest other = (CreateMultiplexRequest)obj;
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getMultiplexSettings() == null ^ this.getMultiplexSettings() == null) {
            return false;
        }
        if (other.getMultiplexSettings() != null && !other.getMultiplexSettings().equals(this.getMultiplexSettings())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getMultiplexSettings() == null ? 0 : this.getMultiplexSettings().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateMultiplexRequest clone() {
        return (CreateMultiplexRequest)super.clone();
    }
}

