/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.VideoSelectorColorSpace;
import com.amazonaws.services.medialive.model.VideoSelectorColorSpaceUsage;
import com.amazonaws.services.medialive.model.VideoSelectorSettings;
import com.amazonaws.services.medialive.model.transform.VideoSelectorMarshaller;
import java.io.Serializable;

public class VideoSelector
implements Serializable,
Cloneable,
StructuredPojo {
    private String colorSpace;
    private String colorSpaceUsage;
    private VideoSelectorSettings selectorSettings;

    public void setColorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
    }

    public String getColorSpace() {
        return this.colorSpace;
    }

    public VideoSelector withColorSpace(String colorSpace) {
        this.setColorSpace(colorSpace);
        return this;
    }

    public VideoSelector withColorSpace(VideoSelectorColorSpace colorSpace) {
        this.colorSpace = colorSpace.toString();
        return this;
    }

    public void setColorSpaceUsage(String colorSpaceUsage) {
        this.colorSpaceUsage = colorSpaceUsage;
    }

    public String getColorSpaceUsage() {
        return this.colorSpaceUsage;
    }

    public VideoSelector withColorSpaceUsage(String colorSpaceUsage) {
        this.setColorSpaceUsage(colorSpaceUsage);
        return this;
    }

    public VideoSelector withColorSpaceUsage(VideoSelectorColorSpaceUsage colorSpaceUsage) {
        this.colorSpaceUsage = colorSpaceUsage.toString();
        return this;
    }

    public void setSelectorSettings(VideoSelectorSettings selectorSettings) {
        this.selectorSettings = selectorSettings;
    }

    public VideoSelectorSettings getSelectorSettings() {
        return this.selectorSettings;
    }

    public VideoSelector withSelectorSettings(VideoSelectorSettings selectorSettings) {
        this.setSelectorSettings(selectorSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColorSpace() != null) {
            sb.append("ColorSpace: ").append(this.getColorSpace()).append(",");
        }
        if (this.getColorSpaceUsage() != null) {
            sb.append("ColorSpaceUsage: ").append(this.getColorSpaceUsage()).append(",");
        }
        if (this.getSelectorSettings() != null) {
            sb.append("SelectorSettings: ").append(this.getSelectorSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        if (other.getColorSpace() == null ^ this.getColorSpace() == null) {
            return false;
        }
        if (other.getColorSpace() != null && !other.getColorSpace().equals(this.getColorSpace())) {
            return false;
        }
        if (other.getColorSpaceUsage() == null ^ this.getColorSpaceUsage() == null) {
            return false;
        }
        if (other.getColorSpaceUsage() != null && !other.getColorSpaceUsage().equals(this.getColorSpaceUsage())) {
            return false;
        }
        if (other.getSelectorSettings() == null ^ this.getSelectorSettings() == null) {
            return false;
        }
        return other.getSelectorSettings() == null || other.getSelectorSettings().equals(this.getSelectorSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColorSpace() == null ? 0 : this.getColorSpace().hashCode());
        hashCode = 31 * hashCode + (this.getColorSpaceUsage() == null ? 0 : this.getColorSpaceUsage().hashCode());
        hashCode = 31 * hashCode + (this.getSelectorSettings() == null ? 0 : this.getSelectorSettings().hashCode());
        return hashCode;
    }

    public VideoSelector clone() {
        try {
            return (VideoSelector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

