/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.medialive.model.EncoderSettings;
import com.amazonaws.services.medialive.model.InputAttachment;
import com.amazonaws.services.medialive.model.InputSpecification;
import com.amazonaws.services.medialive.model.OutputDestination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<OutputDestination> destinations;
    private EncoderSettings encoderSettings;
    private List<InputAttachment> inputAttachments;
    private InputSpecification inputSpecification;
    private String name;
    private String requestId;
    private String reserved;
    private String roleArn;

    public List<OutputDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<OutputDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<OutputDestination>(destinations);
    }

    public CreateChannelRequest withDestinations(OutputDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<OutputDestination>(destinations.length));
        }
        for (OutputDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withDestinations(Collection<OutputDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setEncoderSettings(EncoderSettings encoderSettings) {
        this.encoderSettings = encoderSettings;
    }

    public EncoderSettings getEncoderSettings() {
        return this.encoderSettings;
    }

    public CreateChannelRequest withEncoderSettings(EncoderSettings encoderSettings) {
        this.setEncoderSettings(encoderSettings);
        return this;
    }

    public List<InputAttachment> getInputAttachments() {
        return this.inputAttachments;
    }

    public void setInputAttachments(Collection<InputAttachment> inputAttachments) {
        if (inputAttachments == null) {
            this.inputAttachments = null;
            return;
        }
        this.inputAttachments = new ArrayList<InputAttachment>(inputAttachments);
    }

    public CreateChannelRequest withInputAttachments(InputAttachment ... inputAttachments) {
        if (this.inputAttachments == null) {
            this.setInputAttachments(new ArrayList<InputAttachment>(inputAttachments.length));
        }
        for (InputAttachment ele : inputAttachments) {
            this.inputAttachments.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withInputAttachments(Collection<InputAttachment> inputAttachments) {
        this.setInputAttachments(inputAttachments);
        return this;
    }

    public void setInputSpecification(InputSpecification inputSpecification) {
        this.inputSpecification = inputSpecification;
    }

    public InputSpecification getInputSpecification() {
        return this.inputSpecification;
    }

    public CreateChannelRequest withInputSpecification(InputSpecification inputSpecification) {
        this.setInputSpecification(inputSpecification);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateChannelRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CreateChannelRequest withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public void setReserved(String reserved) {
        this.reserved = reserved;
    }

    public String getReserved() {
        return this.reserved;
    }

    public CreateChannelRequest withReserved(String reserved) {
        this.setReserved(reserved);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateChannelRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getEncoderSettings() != null) {
            sb.append("EncoderSettings: ").append(this.getEncoderSettings()).append(",");
        }
        if (this.getInputAttachments() != null) {
            sb.append("InputAttachments: ").append(this.getInputAttachments()).append(",");
        }
        if (this.getInputSpecification() != null) {
            sb.append("InputSpecification: ").append(this.getInputSpecification()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getReserved() != null) {
            sb.append("Reserved: ").append(this.getReserved()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getEncoderSettings() == null ^ this.getEncoderSettings() == null) {
            return false;
        }
        if (other.getEncoderSettings() != null && !other.getEncoderSettings().equals(this.getEncoderSettings())) {
            return false;
        }
        if (other.getInputAttachments() == null ^ this.getInputAttachments() == null) {
            return false;
        }
        if (other.getInputAttachments() != null && !other.getInputAttachments().equals(this.getInputAttachments())) {
            return false;
        }
        if (other.getInputSpecification() == null ^ this.getInputSpecification() == null) {
            return false;
        }
        if (other.getInputSpecification() != null && !other.getInputSpecification().equals(this.getInputSpecification())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getReserved() == null ^ this.getReserved() == null) {
            return false;
        }
        if (other.getReserved() != null && !other.getReserved().equals(this.getReserved())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        return other.getRoleArn() == null || other.getRoleArn().equals(this.getRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getEncoderSettings() == null ? 0 : this.getEncoderSettings().hashCode());
        hashCode = 31 * hashCode + (this.getInputAttachments() == null ? 0 : this.getInputAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getInputSpecification() == null ? 0 : this.getInputSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getReserved() == null ? 0 : this.getReserved().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        return hashCode;
    }

    public CreateChannelRequest clone() {
        return (CreateChannelRequest)super.clone();
    }
}

