/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.S3DestinationAccessControl;
import com.amazonaws.services.mediaconvert.model.S3EncryptionSettings;
import com.amazonaws.services.mediaconvert.model.S3StorageClass;
import com.amazonaws.services.mediaconvert.model.transform.S3DestinationSettingsMarshaller;
import java.io.Serializable;

public class S3DestinationSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private S3DestinationAccessControl accessControl;
    private S3EncryptionSettings encryption;
    private String storageClass;

    public void setAccessControl(S3DestinationAccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public S3DestinationAccessControl getAccessControl() {
        return this.accessControl;
    }

    public S3DestinationSettings withAccessControl(S3DestinationAccessControl accessControl) {
        this.setAccessControl(accessControl);
        return this;
    }

    public void setEncryption(S3EncryptionSettings encryption) {
        this.encryption = encryption;
    }

    public S3EncryptionSettings getEncryption() {
        return this.encryption;
    }

    public S3DestinationSettings withEncryption(S3EncryptionSettings encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public S3DestinationSettings withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public S3DestinationSettings withStorageClass(S3StorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessControl() != null) {
            sb.append("AccessControl: ").append(this.getAccessControl()).append(",");
        }
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationSettings)) {
            return false;
        }
        S3DestinationSettings other = (S3DestinationSettings)obj;
        if (other.getAccessControl() == null ^ this.getAccessControl() == null) {
            return false;
        }
        if (other.getAccessControl() != null && !other.getAccessControl().equals(this.getAccessControl())) {
            return false;
        }
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        return other.getStorageClass() == null || other.getStorageClass().equals(this.getStorageClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessControl() == null ? 0 : this.getAccessControl().hashCode());
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        return hashCode;
    }

    public S3DestinationSettings clone() {
        try {
            return (S3DestinationSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

