/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AudioChannelTag;
import com.amazonaws.services.mediaconvert.model.transform.AudioChannelTaggingSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AudioChannelTaggingSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String channelTag;
    private List<String> channelTags;

    public void setChannelTag(String channelTag) {
        this.channelTag = channelTag;
    }

    public String getChannelTag() {
        return this.channelTag;
    }

    public AudioChannelTaggingSettings withChannelTag(String channelTag) {
        this.setChannelTag(channelTag);
        return this;
    }

    public AudioChannelTaggingSettings withChannelTag(AudioChannelTag channelTag) {
        this.channelTag = channelTag.toString();
        return this;
    }

    public List<String> getChannelTags() {
        return this.channelTags;
    }

    public void setChannelTags(Collection<String> channelTags) {
        if (channelTags == null) {
            this.channelTags = null;
            return;
        }
        this.channelTags = new ArrayList<String>(channelTags);
    }

    public AudioChannelTaggingSettings withChannelTags(String ... channelTags) {
        if (this.channelTags == null) {
            this.setChannelTags(new ArrayList<String>(channelTags.length));
        }
        for (String ele : channelTags) {
            this.channelTags.add(ele);
        }
        return this;
    }

    public AudioChannelTaggingSettings withChannelTags(Collection<String> channelTags) {
        this.setChannelTags(channelTags);
        return this;
    }

    public AudioChannelTaggingSettings withChannelTags(AudioChannelTag ... channelTags) {
        ArrayList<String> channelTagsCopy = new ArrayList<String>(channelTags.length);
        for (AudioChannelTag value : channelTags) {
            channelTagsCopy.add(value.toString());
        }
        if (this.getChannelTags() == null) {
            this.setChannelTags(channelTagsCopy);
        } else {
            this.getChannelTags().addAll(channelTagsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelTag() != null) {
            sb.append("ChannelTag: ").append(this.getChannelTag()).append(",");
        }
        if (this.getChannelTags() != null) {
            sb.append("ChannelTags: ").append(this.getChannelTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelTaggingSettings)) {
            return false;
        }
        AudioChannelTaggingSettings other = (AudioChannelTaggingSettings)obj;
        if (other.getChannelTag() == null ^ this.getChannelTag() == null) {
            return false;
        }
        if (other.getChannelTag() != null && !other.getChannelTag().equals(this.getChannelTag())) {
            return false;
        }
        if (other.getChannelTags() == null ^ this.getChannelTags() == null) {
            return false;
        }
        return other.getChannelTags() == null || other.getChannelTags().equals(this.getChannelTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelTag() == null ? 0 : this.getChannelTag().hashCode());
        hashCode = 31 * hashCode + (this.getChannelTags() == null ? 0 : this.getChannelTags().hashCode());
        return hashCode;
    }

    public AudioChannelTaggingSettings clone() {
        try {
            return (AudioChannelTaggingSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioChannelTaggingSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

