/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.EncodingName;
import com.amazonaws.services.mediaconnect.model.InputConfigurationRequest;
import com.amazonaws.services.mediaconnect.model.transform.MediaStreamSourceConfigurationRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MediaStreamSourceConfigurationRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String encodingName;
    private List<InputConfigurationRequest> inputConfigurations;
    private String mediaStreamName;

    public void setEncodingName(String encodingName) {
        this.encodingName = encodingName;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public MediaStreamSourceConfigurationRequest withEncodingName(String encodingName) {
        this.setEncodingName(encodingName);
        return this;
    }

    public MediaStreamSourceConfigurationRequest withEncodingName(EncodingName encodingName) {
        this.encodingName = encodingName.toString();
        return this;
    }

    public List<InputConfigurationRequest> getInputConfigurations() {
        return this.inputConfigurations;
    }

    public void setInputConfigurations(Collection<InputConfigurationRequest> inputConfigurations) {
        if (inputConfigurations == null) {
            this.inputConfigurations = null;
            return;
        }
        this.inputConfigurations = new ArrayList<InputConfigurationRequest>(inputConfigurations);
    }

    public MediaStreamSourceConfigurationRequest withInputConfigurations(InputConfigurationRequest ... inputConfigurations) {
        if (this.inputConfigurations == null) {
            this.setInputConfigurations(new ArrayList<InputConfigurationRequest>(inputConfigurations.length));
        }
        for (InputConfigurationRequest ele : inputConfigurations) {
            this.inputConfigurations.add(ele);
        }
        return this;
    }

    public MediaStreamSourceConfigurationRequest withInputConfigurations(Collection<InputConfigurationRequest> inputConfigurations) {
        this.setInputConfigurations(inputConfigurations);
        return this;
    }

    public void setMediaStreamName(String mediaStreamName) {
        this.mediaStreamName = mediaStreamName;
    }

    public String getMediaStreamName() {
        return this.mediaStreamName;
    }

    public MediaStreamSourceConfigurationRequest withMediaStreamName(String mediaStreamName) {
        this.setMediaStreamName(mediaStreamName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncodingName() != null) {
            sb.append("EncodingName: ").append(this.getEncodingName()).append(",");
        }
        if (this.getInputConfigurations() != null) {
            sb.append("InputConfigurations: ").append(this.getInputConfigurations()).append(",");
        }
        if (this.getMediaStreamName() != null) {
            sb.append("MediaStreamName: ").append(this.getMediaStreamName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamSourceConfigurationRequest)) {
            return false;
        }
        MediaStreamSourceConfigurationRequest other = (MediaStreamSourceConfigurationRequest)obj;
        if (other.getEncodingName() == null ^ this.getEncodingName() == null) {
            return false;
        }
        if (other.getEncodingName() != null && !other.getEncodingName().equals(this.getEncodingName())) {
            return false;
        }
        if (other.getInputConfigurations() == null ^ this.getInputConfigurations() == null) {
            return false;
        }
        if (other.getInputConfigurations() != null && !other.getInputConfigurations().equals(this.getInputConfigurations())) {
            return false;
        }
        if (other.getMediaStreamName() == null ^ this.getMediaStreamName() == null) {
            return false;
        }
        return other.getMediaStreamName() == null || other.getMediaStreamName().equals(this.getMediaStreamName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncodingName() == null ? 0 : this.getEncodingName().hashCode());
        hashCode = 31 * hashCode + (this.getInputConfigurations() == null ? 0 : this.getInputConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getMediaStreamName() == null ? 0 : this.getMediaStreamName().hashCode());
        return hashCode;
    }

    public MediaStreamSourceConfigurationRequest clone() {
        try {
            return (MediaStreamSourceConfigurationRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MediaStreamSourceConfigurationRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

