/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.TransportStreamProgram;
import com.amazonaws.services.mediaconnect.model.transform.TransportMediaInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransportMediaInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TransportStreamProgram> programs;

    public List<TransportStreamProgram> getPrograms() {
        return this.programs;
    }

    public void setPrograms(Collection<TransportStreamProgram> programs) {
        if (programs == null) {
            this.programs = null;
            return;
        }
        this.programs = new ArrayList<TransportStreamProgram>(programs);
    }

    public TransportMediaInfo withPrograms(TransportStreamProgram ... programs) {
        if (this.programs == null) {
            this.setPrograms(new ArrayList<TransportStreamProgram>(programs.length));
        }
        for (TransportStreamProgram ele : programs) {
            this.programs.add(ele);
        }
        return this;
    }

    public TransportMediaInfo withPrograms(Collection<TransportStreamProgram> programs) {
        this.setPrograms(programs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrograms() != null) {
            sb.append("Programs: ").append(this.getPrograms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportMediaInfo)) {
            return false;
        }
        TransportMediaInfo other = (TransportMediaInfo)obj;
        if (other.getPrograms() == null ^ this.getPrograms() == null) {
            return false;
        }
        return other.getPrograms() == null || other.getPrograms().equals(this.getPrograms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrograms() == null ? 0 : this.getPrograms().hashCode());
        return hashCode;
    }

    public TransportMediaInfo clone() {
        try {
            return (TransportMediaInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransportMediaInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

