/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconnect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * The settings for an instance in a gateway.
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GatewayInstance" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GatewayInstance implements Serializable, Cloneable, StructuredPojo {

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     */
    private String bridgePlacement;
    /** The connection state of the instance. */
    private String connectionStatus;
    /** The Amazon Resource Name (ARN) of the instance. */
    private String gatewayArn;
    /** The Amazon Resource Name (ARN) of the gateway. */
    private String gatewayInstanceArn;
    /** The managed instance ID generated by the SSM install. This will begin with "mi-". */
    private String instanceId;

    private java.util.List<MessageDetail> instanceMessages;
    /** The status of the instance. */
    private String instanceState;
    /** The running bridge count. */
    private Integer runningBridgeCount;

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * 
     * @param bridgePlacement
     *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *        bridges can be added to this instance.
     * @see BridgePlacement
     */

    public void setBridgePlacement(String bridgePlacement) {
        this.bridgePlacement = bridgePlacement;
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * 
     * @return The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *         AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *         bridges can be added to this instance.
     * @see BridgePlacement
     */

    public String getBridgePlacement() {
        return this.bridgePlacement;
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * 
     * @param bridgePlacement
     *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *        bridges can be added to this instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see BridgePlacement
     */

    public GatewayInstance withBridgePlacement(String bridgePlacement) {
        setBridgePlacement(bridgePlacement);
        return this;
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * 
     * @param bridgePlacement
     *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *        bridges can be added to this instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see BridgePlacement
     */

    public GatewayInstance withBridgePlacement(BridgePlacement bridgePlacement) {
        this.bridgePlacement = bridgePlacement.toString();
        return this;
    }

    /**
     * The connection state of the instance.
     * 
     * @param connectionStatus
     *        The connection state of the instance.
     * @see ConnectionStatus
     */

    public void setConnectionStatus(String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    /**
     * The connection state of the instance.
     * 
     * @return The connection state of the instance.
     * @see ConnectionStatus
     */

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    /**
     * The connection state of the instance.
     * 
     * @param connectionStatus
     *        The connection state of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ConnectionStatus
     */

    public GatewayInstance withConnectionStatus(String connectionStatus) {
        setConnectionStatus(connectionStatus);
        return this;
    }

    /**
     * The connection state of the instance.
     * 
     * @param connectionStatus
     *        The connection state of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ConnectionStatus
     */

    public GatewayInstance withConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus.toString();
        return this;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * 
     * @param gatewayArn
     *        The Amazon Resource Name (ARN) of the instance.
     */

    public void setGatewayArn(String gatewayArn) {
        this.gatewayArn = gatewayArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */

    public String getGatewayArn() {
        return this.gatewayArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * 
     * @param gatewayArn
     *        The Amazon Resource Name (ARN) of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GatewayInstance withGatewayArn(String gatewayArn) {
        setGatewayArn(gatewayArn);
        return this;
    }

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     * @param gatewayInstanceArn
     *        The Amazon Resource Name (ARN) of the gateway.
     */

    public void setGatewayInstanceArn(String gatewayInstanceArn) {
        this.gatewayInstanceArn = gatewayInstanceArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     * @return The Amazon Resource Name (ARN) of the gateway.
     */

    public String getGatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     * @param gatewayInstanceArn
     *        The Amazon Resource Name (ARN) of the gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GatewayInstance withGatewayInstanceArn(String gatewayInstanceArn) {
        setGatewayInstanceArn(gatewayInstanceArn);
        return this;
    }

    /**
     * The managed instance ID generated by the SSM install. This will begin with "mi-".
     * 
     * @param instanceId
     *        The managed instance ID generated by the SSM install. This will begin with "mi-".
     */

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * The managed instance ID generated by the SSM install. This will begin with "mi-".
     * 
     * @return The managed instance ID generated by the SSM install. This will begin with "mi-".
     */

    public String getInstanceId() {
        return this.instanceId;
    }

    /**
     * The managed instance ID generated by the SSM install. This will begin with "mi-".
     * 
     * @param instanceId
     *        The managed instance ID generated by the SSM install. This will begin with "mi-".
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GatewayInstance withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * @return
     */

    public java.util.List<MessageDetail> getInstanceMessages() {
        return instanceMessages;
    }

    /**
     * @param instanceMessages
     */

    public void setInstanceMessages(java.util.Collection<MessageDetail> instanceMessages) {
        if (instanceMessages == null) {
            this.instanceMessages = null;
            return;
        }

        this.instanceMessages = new java.util.ArrayList<MessageDetail>(instanceMessages);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInstanceMessages(java.util.Collection)} or {@link #withInstanceMessages(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param instanceMessages
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GatewayInstance withInstanceMessages(MessageDetail... instanceMessages) {
        if (this.instanceMessages == null) {
            setInstanceMessages(new java.util.ArrayList<MessageDetail>(instanceMessages.length));
        }
        for (MessageDetail ele : instanceMessages) {
            this.instanceMessages.add(ele);
        }
        return this;
    }

    /**
     * @param instanceMessages
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GatewayInstance withInstanceMessages(java.util.Collection<MessageDetail> instanceMessages) {
        setInstanceMessages(instanceMessages);
        return this;
    }

    /**
     * The status of the instance.
     * 
     * @param instanceState
     *        The status of the instance.
     * @see InstanceState
     */

    public void setInstanceState(String instanceState) {
        this.instanceState = instanceState;
    }

    /**
     * The status of the instance.
     * 
     * @return The status of the instance.
     * @see InstanceState
     */

    public String getInstanceState() {
        return this.instanceState;
    }

    /**
     * The status of the instance.
     * 
     * @param instanceState
     *        The status of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceState
     */

    public GatewayInstance withInstanceState(String instanceState) {
        setInstanceState(instanceState);
        return this;
    }

    /**
     * The status of the instance.
     * 
     * @param instanceState
     *        The status of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceState
     */

    public GatewayInstance withInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState.toString();
        return this;
    }

    /**
     * The running bridge count.
     * 
     * @param runningBridgeCount
     *        The running bridge count.
     */

    public void setRunningBridgeCount(Integer runningBridgeCount) {
        this.runningBridgeCount = runningBridgeCount;
    }

    /**
     * The running bridge count.
     * 
     * @return The running bridge count.
     */

    public Integer getRunningBridgeCount() {
        return this.runningBridgeCount;
    }

    /**
     * The running bridge count.
     * 
     * @param runningBridgeCount
     *        The running bridge count.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GatewayInstance withRunningBridgeCount(Integer runningBridgeCount) {
        setRunningBridgeCount(runningBridgeCount);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBridgePlacement() != null)
            sb.append("BridgePlacement: ").append(getBridgePlacement()).append(",");
        if (getConnectionStatus() != null)
            sb.append("ConnectionStatus: ").append(getConnectionStatus()).append(",");
        if (getGatewayArn() != null)
            sb.append("GatewayArn: ").append(getGatewayArn()).append(",");
        if (getGatewayInstanceArn() != null)
            sb.append("GatewayInstanceArn: ").append(getGatewayInstanceArn()).append(",");
        if (getInstanceId() != null)
            sb.append("InstanceId: ").append(getInstanceId()).append(",");
        if (getInstanceMessages() != null)
            sb.append("InstanceMessages: ").append(getInstanceMessages()).append(",");
        if (getInstanceState() != null)
            sb.append("InstanceState: ").append(getInstanceState()).append(",");
        if (getRunningBridgeCount() != null)
            sb.append("RunningBridgeCount: ").append(getRunningBridgeCount());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GatewayInstance == false)
            return false;
        GatewayInstance other = (GatewayInstance) obj;
        if (other.getBridgePlacement() == null ^ this.getBridgePlacement() == null)
            return false;
        if (other.getBridgePlacement() != null && other.getBridgePlacement().equals(this.getBridgePlacement()) == false)
            return false;
        if (other.getConnectionStatus() == null ^ this.getConnectionStatus() == null)
            return false;
        if (other.getConnectionStatus() != null && other.getConnectionStatus().equals(this.getConnectionStatus()) == false)
            return false;
        if (other.getGatewayArn() == null ^ this.getGatewayArn() == null)
            return false;
        if (other.getGatewayArn() != null && other.getGatewayArn().equals(this.getGatewayArn()) == false)
            return false;
        if (other.getGatewayInstanceArn() == null ^ this.getGatewayInstanceArn() == null)
            return false;
        if (other.getGatewayInstanceArn() != null && other.getGatewayInstanceArn().equals(this.getGatewayInstanceArn()) == false)
            return false;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null)
            return false;
        if (other.getInstanceId() != null && other.getInstanceId().equals(this.getInstanceId()) == false)
            return false;
        if (other.getInstanceMessages() == null ^ this.getInstanceMessages() == null)
            return false;
        if (other.getInstanceMessages() != null && other.getInstanceMessages().equals(this.getInstanceMessages()) == false)
            return false;
        if (other.getInstanceState() == null ^ this.getInstanceState() == null)
            return false;
        if (other.getInstanceState() != null && other.getInstanceState().equals(this.getInstanceState()) == false)
            return false;
        if (other.getRunningBridgeCount() == null ^ this.getRunningBridgeCount() == null)
            return false;
        if (other.getRunningBridgeCount() != null && other.getRunningBridgeCount().equals(this.getRunningBridgeCount()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBridgePlacement() == null) ? 0 : getBridgePlacement().hashCode());
        hashCode = prime * hashCode + ((getConnectionStatus() == null) ? 0 : getConnectionStatus().hashCode());
        hashCode = prime * hashCode + ((getGatewayArn() == null) ? 0 : getGatewayArn().hashCode());
        hashCode = prime * hashCode + ((getGatewayInstanceArn() == null) ? 0 : getGatewayInstanceArn().hashCode());
        hashCode = prime * hashCode + ((getInstanceId() == null) ? 0 : getInstanceId().hashCode());
        hashCode = prime * hashCode + ((getInstanceMessages() == null) ? 0 : getInstanceMessages().hashCode());
        hashCode = prime * hashCode + ((getInstanceState() == null) ? 0 : getInstanceState().hashCode());
        hashCode = prime * hashCode + ((getRunningBridgeCount() == null) ? 0 : getRunningBridgeCount().hashCode());
        return hashCode;
    }

    @Override
    public GatewayInstance clone() {
        try {
            return (GatewayInstance) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mediaconnect.model.transform.GatewayInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
