/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mturk.model.Comparator;
import com.amazonaws.services.mturk.model.HITAccessActions;
import com.amazonaws.services.mturk.model.Locale;
import com.amazonaws.services.mturk.model.transform.QualificationRequirementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QualificationRequirement
implements Serializable,
Cloneable,
StructuredPojo {
    private String qualificationTypeId;
    private String comparator;
    private List<Integer> integerValues;
    private List<Locale> localeValues;
    @Deprecated
    private Boolean requiredToPreview;
    private String actionsGuarded;

    public void setQualificationTypeId(String qualificationTypeId) {
        this.qualificationTypeId = qualificationTypeId;
    }

    public String getQualificationTypeId() {
        return this.qualificationTypeId;
    }

    public QualificationRequirement withQualificationTypeId(String qualificationTypeId) {
        this.setQualificationTypeId(qualificationTypeId);
        return this;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public String getComparator() {
        return this.comparator;
    }

    public QualificationRequirement withComparator(String comparator) {
        this.setComparator(comparator);
        return this;
    }

    public void setComparator(Comparator comparator) {
        this.withComparator(comparator);
    }

    public QualificationRequirement withComparator(Comparator comparator) {
        this.comparator = comparator.toString();
        return this;
    }

    public List<Integer> getIntegerValues() {
        return this.integerValues;
    }

    public void setIntegerValues(Collection<Integer> integerValues) {
        if (integerValues == null) {
            this.integerValues = null;
            return;
        }
        this.integerValues = new ArrayList<Integer>(integerValues);
    }

    public QualificationRequirement withIntegerValues(Integer ... integerValues) {
        if (this.integerValues == null) {
            this.setIntegerValues(new ArrayList<Integer>(integerValues.length));
        }
        for (Integer ele : integerValues) {
            this.integerValues.add(ele);
        }
        return this;
    }

    public QualificationRequirement withIntegerValues(Collection<Integer> integerValues) {
        this.setIntegerValues(integerValues);
        return this;
    }

    public List<Locale> getLocaleValues() {
        return this.localeValues;
    }

    public void setLocaleValues(Collection<Locale> localeValues) {
        if (localeValues == null) {
            this.localeValues = null;
            return;
        }
        this.localeValues = new ArrayList<Locale>(localeValues);
    }

    public QualificationRequirement withLocaleValues(Locale ... localeValues) {
        if (this.localeValues == null) {
            this.setLocaleValues(new ArrayList<Locale>(localeValues.length));
        }
        for (Locale ele : localeValues) {
            this.localeValues.add(ele);
        }
        return this;
    }

    public QualificationRequirement withLocaleValues(Collection<Locale> localeValues) {
        this.setLocaleValues(localeValues);
        return this;
    }

    @Deprecated
    public void setRequiredToPreview(Boolean requiredToPreview) {
        this.requiredToPreview = requiredToPreview;
    }

    @Deprecated
    public Boolean getRequiredToPreview() {
        return this.requiredToPreview;
    }

    @Deprecated
    public QualificationRequirement withRequiredToPreview(Boolean requiredToPreview) {
        this.setRequiredToPreview(requiredToPreview);
        return this;
    }

    @Deprecated
    public Boolean isRequiredToPreview() {
        return this.requiredToPreview;
    }

    public void setActionsGuarded(String actionsGuarded) {
        this.actionsGuarded = actionsGuarded;
    }

    public String getActionsGuarded() {
        return this.actionsGuarded;
    }

    public QualificationRequirement withActionsGuarded(String actionsGuarded) {
        this.setActionsGuarded(actionsGuarded);
        return this;
    }

    public void setActionsGuarded(HITAccessActions actionsGuarded) {
        this.withActionsGuarded(actionsGuarded);
    }

    public QualificationRequirement withActionsGuarded(HITAccessActions actionsGuarded) {
        this.actionsGuarded = actionsGuarded.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQualificationTypeId() != null) {
            sb.append("QualificationTypeId: ").append(this.getQualificationTypeId()).append(",");
        }
        if (this.getComparator() != null) {
            sb.append("Comparator: ").append(this.getComparator()).append(",");
        }
        if (this.getIntegerValues() != null) {
            sb.append("IntegerValues: ").append(this.getIntegerValues()).append(",");
        }
        if (this.getLocaleValues() != null) {
            sb.append("LocaleValues: ").append(this.getLocaleValues()).append(",");
        }
        if (this.getRequiredToPreview() != null) {
            sb.append("RequiredToPreview: ").append(this.getRequiredToPreview()).append(",");
        }
        if (this.getActionsGuarded() != null) {
            sb.append("ActionsGuarded: ").append(this.getActionsGuarded());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualificationRequirement)) {
            return false;
        }
        QualificationRequirement other = (QualificationRequirement)obj;
        if (other.getQualificationTypeId() == null ^ this.getQualificationTypeId() == null) {
            return false;
        }
        if (other.getQualificationTypeId() != null && !other.getQualificationTypeId().equals(this.getQualificationTypeId())) {
            return false;
        }
        if (other.getComparator() == null ^ this.getComparator() == null) {
            return false;
        }
        if (other.getComparator() != null && !other.getComparator().equals(this.getComparator())) {
            return false;
        }
        if (other.getIntegerValues() == null ^ this.getIntegerValues() == null) {
            return false;
        }
        if (other.getIntegerValues() != null && !other.getIntegerValues().equals(this.getIntegerValues())) {
            return false;
        }
        if (other.getLocaleValues() == null ^ this.getLocaleValues() == null) {
            return false;
        }
        if (other.getLocaleValues() != null && !other.getLocaleValues().equals(this.getLocaleValues())) {
            return false;
        }
        if (other.getRequiredToPreview() == null ^ this.getRequiredToPreview() == null) {
            return false;
        }
        if (other.getRequiredToPreview() != null && !other.getRequiredToPreview().equals(this.getRequiredToPreview())) {
            return false;
        }
        if (other.getActionsGuarded() == null ^ this.getActionsGuarded() == null) {
            return false;
        }
        return other.getActionsGuarded() == null || other.getActionsGuarded().equals(this.getActionsGuarded());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQualificationTypeId() == null ? 0 : this.getQualificationTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getComparator() == null ? 0 : this.getComparator().hashCode());
        hashCode = 31 * hashCode + (this.getIntegerValues() == null ? 0 : this.getIntegerValues().hashCode());
        hashCode = 31 * hashCode + (this.getLocaleValues() == null ? 0 : this.getLocaleValues().hashCode());
        hashCode = 31 * hashCode + (this.getRequiredToPreview() == null ? 0 : this.getRequiredToPreview().hashCode());
        hashCode = 31 * hashCode + (this.getActionsGuarded() == null ? 0 : this.getActionsGuarded().hashCode());
        return hashCode;
    }

    public QualificationRequirement clone() {
        try {
            return (QualificationRequirement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QualificationRequirementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

