/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMetering;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMeteringClientBuilder;
import com.amazonaws.services.marketplacemetering.model.AWSMarketplaceMeteringException;
import com.amazonaws.services.marketplacemetering.model.BatchMeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.BatchMeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.DuplicateRequestException;
import com.amazonaws.services.marketplacemetering.model.ExpiredTokenException;
import com.amazonaws.services.marketplacemetering.model.InternalServiceErrorException;
import com.amazonaws.services.marketplacemetering.model.InvalidCustomerIdentifierException;
import com.amazonaws.services.marketplacemetering.model.InvalidEndpointRegionException;
import com.amazonaws.services.marketplacemetering.model.InvalidProductCodeException;
import com.amazonaws.services.marketplacemetering.model.InvalidTokenException;
import com.amazonaws.services.marketplacemetering.model.InvalidUsageDimensionException;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.MeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.ResolveCustomerRequest;
import com.amazonaws.services.marketplacemetering.model.ResolveCustomerResult;
import com.amazonaws.services.marketplacemetering.model.ThrottlingException;
import com.amazonaws.services.marketplacemetering.model.TimestampOutOfBoundsException;
import com.amazonaws.services.marketplacemetering.model.transform.BatchMeterUsageRequestMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.BatchMeterUsageResultJsonUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.MeterUsageRequestMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.MeterUsageResultJsonUnmarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.ResolveCustomerRequestMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.ResolveCustomerResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMarketplaceMeteringClient
extends AmazonWebServiceClient
implements AWSMarketplaceMetering {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMarketplaceMetering.class);
    private static final String DEFAULT_SIGNING_NAME = "aws-marketplace";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTokenException").withModeledClass(InvalidTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredTokenException").withModeledClass(ExpiredTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEndpointRegionException").withModeledClass(InvalidEndpointRegionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TimestampOutOfBoundsException").withModeledClass(TimestampOutOfBoundsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withModeledClass(InternalServiceErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidUsageDimensionException").withModeledClass(InvalidUsageDimensionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequestException").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCustomerIdentifierException").withModeledClass(InvalidCustomerIdentifierException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidProductCodeException").withModeledClass(InvalidProductCodeException.class)).withBaseServiceExceptionClass(AWSMarketplaceMeteringException.class));

    @Deprecated
    public AWSMarketplaceMeteringClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSMarketplaceMeteringClientBuilder builder() {
        return AWSMarketplaceMeteringClientBuilder.standard();
    }

    AWSMarketplaceMeteringClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("metering.marketplace");
        this.setEndpoint("https://metering.marketplace.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/marketplacemetering/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/marketplacemetering/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchMeterUsageResult batchMeterUsage(BatchMeterUsageRequest batchMeterUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchMeterUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchMeterUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchMeterUsageRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((BatchMeterUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchMeterUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchMeterUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchMeterUsageResult batchMeterUsageResult = (BatchMeterUsageResult)response.getAwsResponse();
            return batchMeterUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeterUsageResult meterUsage(MeterUsageRequest meterUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(meterUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<MeterUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new MeterUsageRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((MeterUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)meterUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new MeterUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            MeterUsageResult meterUsageResult = (MeterUsageResult)response.getAwsResponse();
            return meterUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveCustomerResult resolveCustomer(ResolveCustomerRequest resolveCustomerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resolveCustomerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResolveCustomerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResolveCustomerRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ResolveCustomerRequest)super.beforeMarshalling((AmazonWebServiceRequest)resolveCustomerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResolveCustomerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResolveCustomerResult resolveCustomerResult = (ResolveCustomerResult)response.getAwsResponse();
            return resolveCustomerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

