/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplacecatalog.model.OfferStateString;
import com.amazonaws.services.marketplacecatalog.model.OfferTargetingString;
import com.amazonaws.services.marketplacecatalog.model.transform.OfferSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OfferSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String productId;
    private String releaseDate;
    private String availabilityEndDate;
    private List<String> buyerAccounts;
    private String state;
    private List<String> targeting;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OfferSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductId() {
        return this.productId;
    }

    public OfferSummary withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public OfferSummary withReleaseDate(String releaseDate) {
        this.setReleaseDate(releaseDate);
        return this;
    }

    public void setAvailabilityEndDate(String availabilityEndDate) {
        this.availabilityEndDate = availabilityEndDate;
    }

    public String getAvailabilityEndDate() {
        return this.availabilityEndDate;
    }

    public OfferSummary withAvailabilityEndDate(String availabilityEndDate) {
        this.setAvailabilityEndDate(availabilityEndDate);
        return this;
    }

    public List<String> getBuyerAccounts() {
        return this.buyerAccounts;
    }

    public void setBuyerAccounts(Collection<String> buyerAccounts) {
        if (buyerAccounts == null) {
            this.buyerAccounts = null;
            return;
        }
        this.buyerAccounts = new ArrayList<String>(buyerAccounts);
    }

    public OfferSummary withBuyerAccounts(String ... buyerAccounts) {
        if (this.buyerAccounts == null) {
            this.setBuyerAccounts(new ArrayList<String>(buyerAccounts.length));
        }
        for (String ele : buyerAccounts) {
            this.buyerAccounts.add(ele);
        }
        return this;
    }

    public OfferSummary withBuyerAccounts(Collection<String> buyerAccounts) {
        this.setBuyerAccounts(buyerAccounts);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public OfferSummary withState(String state) {
        this.setState(state);
        return this;
    }

    public OfferSummary withState(OfferStateString state) {
        this.state = state.toString();
        return this;
    }

    public List<String> getTargeting() {
        return this.targeting;
    }

    public void setTargeting(Collection<String> targeting) {
        if (targeting == null) {
            this.targeting = null;
            return;
        }
        this.targeting = new ArrayList<String>(targeting);
    }

    public OfferSummary withTargeting(String ... targeting) {
        if (this.targeting == null) {
            this.setTargeting(new ArrayList<String>(targeting.length));
        }
        for (String ele : targeting) {
            this.targeting.add(ele);
        }
        return this;
    }

    public OfferSummary withTargeting(Collection<String> targeting) {
        this.setTargeting(targeting);
        return this;
    }

    public OfferSummary withTargeting(OfferTargetingString ... targeting) {
        ArrayList<String> targetingCopy = new ArrayList<String>(targeting.length);
        for (OfferTargetingString value : targeting) {
            targetingCopy.add(value.toString());
        }
        if (this.getTargeting() == null) {
            this.setTargeting(targetingCopy);
        } else {
            this.getTargeting().addAll(targetingCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProductId() != null) {
            sb.append("ProductId: ").append(this.getProductId()).append(",");
        }
        if (this.getReleaseDate() != null) {
            sb.append("ReleaseDate: ").append(this.getReleaseDate()).append(",");
        }
        if (this.getAvailabilityEndDate() != null) {
            sb.append("AvailabilityEndDate: ").append(this.getAvailabilityEndDate()).append(",");
        }
        if (this.getBuyerAccounts() != null) {
            sb.append("BuyerAccounts: ").append(this.getBuyerAccounts()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTargeting() != null) {
            sb.append("Targeting: ").append(this.getTargeting());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferSummary)) {
            return false;
        }
        OfferSummary other = (OfferSummary)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProductId() == null ^ this.getProductId() == null) {
            return false;
        }
        if (other.getProductId() != null && !other.getProductId().equals(this.getProductId())) {
            return false;
        }
        if (other.getReleaseDate() == null ^ this.getReleaseDate() == null) {
            return false;
        }
        if (other.getReleaseDate() != null && !other.getReleaseDate().equals(this.getReleaseDate())) {
            return false;
        }
        if (other.getAvailabilityEndDate() == null ^ this.getAvailabilityEndDate() == null) {
            return false;
        }
        if (other.getAvailabilityEndDate() != null && !other.getAvailabilityEndDate().equals(this.getAvailabilityEndDate())) {
            return false;
        }
        if (other.getBuyerAccounts() == null ^ this.getBuyerAccounts() == null) {
            return false;
        }
        if (other.getBuyerAccounts() != null && !other.getBuyerAccounts().equals(this.getBuyerAccounts())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTargeting() == null ^ this.getTargeting() == null) {
            return false;
        }
        return other.getTargeting() == null || other.getTargeting().equals(this.getTargeting());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProductId() == null ? 0 : this.getProductId().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseDate() == null ? 0 : this.getReleaseDate().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityEndDate() == null ? 0 : this.getAvailabilityEndDate().hashCode());
        hashCode = 31 * hashCode + (this.getBuyerAccounts() == null ? 0 : this.getBuyerAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTargeting() == null ? 0 : this.getTargeting().hashCode());
        return hashCode;
    }

    public OfferSummary clone() {
        try {
            return (OfferSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

