/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceagreement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplaceagreement.model.DocumentItem;
import com.amazonaws.services.marketplaceagreement.model.transform.LegalTermMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LegalTerm
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DocumentItem> documents;
    private String type;

    public List<DocumentItem> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Collection<DocumentItem> documents) {
        if (documents == null) {
            this.documents = null;
            return;
        }
        this.documents = new ArrayList<DocumentItem>(documents);
    }

    public LegalTerm withDocuments(DocumentItem ... documents) {
        if (this.documents == null) {
            this.setDocuments(new ArrayList<DocumentItem>(documents.length));
        }
        for (DocumentItem ele : documents) {
            this.documents.add(ele);
        }
        return this;
    }

    public LegalTerm withDocuments(Collection<DocumentItem> documents) {
        this.setDocuments(documents);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public LegalTerm withType(String type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocuments() != null) {
            sb.append("Documents: ").append(this.getDocuments()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegalTerm)) {
            return false;
        }
        LegalTerm other = (LegalTerm)obj;
        if (other.getDocuments() == null ^ this.getDocuments() == null) {
            return false;
        }
        if (other.getDocuments() != null && !other.getDocuments().equals(this.getDocuments())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocuments() == null ? 0 : this.getDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public LegalTerm clone() {
        try {
            return (LegalTerm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LegalTermMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

