/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.AuthenticationProviderTypes;
import com.amazonaws.services.managedgrafana.model.AwsSsoAuthentication;
import com.amazonaws.services.managedgrafana.model.SamlAuthentication;
import com.amazonaws.services.managedgrafana.model.transform.AuthenticationDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthenticationDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private AwsSsoAuthentication awsSso;
    private List<String> providers;
    private SamlAuthentication saml;

    public void setAwsSso(AwsSsoAuthentication awsSso) {
        this.awsSso = awsSso;
    }

    public AwsSsoAuthentication getAwsSso() {
        return this.awsSso;
    }

    public AuthenticationDescription withAwsSso(AwsSsoAuthentication awsSso) {
        this.setAwsSso(awsSso);
        return this;
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public void setProviders(Collection<String> providers) {
        if (providers == null) {
            this.providers = null;
            return;
        }
        this.providers = new ArrayList<String>(providers);
    }

    public AuthenticationDescription withProviders(String ... providers) {
        if (this.providers == null) {
            this.setProviders(new ArrayList<String>(providers.length));
        }
        for (String ele : providers) {
            this.providers.add(ele);
        }
        return this;
    }

    public AuthenticationDescription withProviders(Collection<String> providers) {
        this.setProviders(providers);
        return this;
    }

    public AuthenticationDescription withProviders(AuthenticationProviderTypes ... providers) {
        ArrayList<String> providersCopy = new ArrayList<String>(providers.length);
        for (AuthenticationProviderTypes value : providers) {
            providersCopy.add(value.toString());
        }
        if (this.getProviders() == null) {
            this.setProviders(providersCopy);
        } else {
            this.getProviders().addAll(providersCopy);
        }
        return this;
    }

    public void setSaml(SamlAuthentication saml) {
        this.saml = saml;
    }

    public SamlAuthentication getSaml() {
        return this.saml;
    }

    public AuthenticationDescription withSaml(SamlAuthentication saml) {
        this.setSaml(saml);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsSso() != null) {
            sb.append("AwsSso: ").append(this.getAwsSso()).append(",");
        }
        if (this.getProviders() != null) {
            sb.append("Providers: ").append(this.getProviders()).append(",");
        }
        if (this.getSaml() != null) {
            sb.append("Saml: ").append(this.getSaml());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationDescription)) {
            return false;
        }
        AuthenticationDescription other = (AuthenticationDescription)obj;
        if (other.getAwsSso() == null ^ this.getAwsSso() == null) {
            return false;
        }
        if (other.getAwsSso() != null && !other.getAwsSso().equals(this.getAwsSso())) {
            return false;
        }
        if (other.getProviders() == null ^ this.getProviders() == null) {
            return false;
        }
        if (other.getProviders() != null && !other.getProviders().equals(this.getProviders())) {
            return false;
        }
        if (other.getSaml() == null ^ this.getSaml() == null) {
            return false;
        }
        return other.getSaml() == null || other.getSaml().equals(this.getSaml());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsSso() == null ? 0 : this.getAwsSso().hashCode());
        hashCode = 31 * hashCode + (this.getProviders() == null ? 0 : this.getProviders().hashCode());
        hashCode = 31 * hashCode + (this.getSaml() == null ? 0 : this.getSaml().hashCode());
        return hashCode;
    }

    public AuthenticationDescription clone() {
        try {
            return (AuthenticationDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

