/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.managedgrafana.model.AccountAccessType;
import com.amazonaws.services.managedgrafana.model.AuthenticationProviderTypes;
import com.amazonaws.services.managedgrafana.model.DataSourceType;
import com.amazonaws.services.managedgrafana.model.NetworkAccessConfiguration;
import com.amazonaws.services.managedgrafana.model.NotificationDestinationType;
import com.amazonaws.services.managedgrafana.model.PermissionType;
import com.amazonaws.services.managedgrafana.model.VpcConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateWorkspaceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountAccessType;
    private List<String> authenticationProviders;
    private String clientToken;
    private String configuration;
    private NetworkAccessConfiguration networkAccessControl;
    private String organizationRoleName;
    private String permissionType;
    private String stackSetName;
    private Map<String, String> tags;
    private VpcConfiguration vpcConfiguration;
    private List<String> workspaceDataSources;
    private String workspaceDescription;
    private String workspaceName;
    private List<String> workspaceNotificationDestinations;
    private List<String> workspaceOrganizationalUnits;
    private String workspaceRoleArn;

    public void setAccountAccessType(String accountAccessType) {
        this.accountAccessType = accountAccessType;
    }

    public String getAccountAccessType() {
        return this.accountAccessType;
    }

    public CreateWorkspaceRequest withAccountAccessType(String accountAccessType) {
        this.setAccountAccessType(accountAccessType);
        return this;
    }

    public CreateWorkspaceRequest withAccountAccessType(AccountAccessType accountAccessType) {
        this.accountAccessType = accountAccessType.toString();
        return this;
    }

    public List<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public void setAuthenticationProviders(Collection<String> authenticationProviders) {
        if (authenticationProviders == null) {
            this.authenticationProviders = null;
            return;
        }
        this.authenticationProviders = new ArrayList<String>(authenticationProviders);
    }

    public CreateWorkspaceRequest withAuthenticationProviders(String ... authenticationProviders) {
        if (this.authenticationProviders == null) {
            this.setAuthenticationProviders(new ArrayList<String>(authenticationProviders.length));
        }
        for (String ele : authenticationProviders) {
            this.authenticationProviders.add(ele);
        }
        return this;
    }

    public CreateWorkspaceRequest withAuthenticationProviders(Collection<String> authenticationProviders) {
        this.setAuthenticationProviders(authenticationProviders);
        return this;
    }

    public CreateWorkspaceRequest withAuthenticationProviders(AuthenticationProviderTypes ... authenticationProviders) {
        ArrayList<String> authenticationProvidersCopy = new ArrayList<String>(authenticationProviders.length);
        for (AuthenticationProviderTypes value : authenticationProviders) {
            authenticationProvidersCopy.add(value.toString());
        }
        if (this.getAuthenticationProviders() == null) {
            this.setAuthenticationProviders(authenticationProvidersCopy);
        } else {
            this.getAuthenticationProviders().addAll(authenticationProvidersCopy);
        }
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateWorkspaceRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public CreateWorkspaceRequest withConfiguration(String configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setNetworkAccessControl(NetworkAccessConfiguration networkAccessControl) {
        this.networkAccessControl = networkAccessControl;
    }

    public NetworkAccessConfiguration getNetworkAccessControl() {
        return this.networkAccessControl;
    }

    public CreateWorkspaceRequest withNetworkAccessControl(NetworkAccessConfiguration networkAccessControl) {
        this.setNetworkAccessControl(networkAccessControl);
        return this;
    }

    public void setOrganizationRoleName(String organizationRoleName) {
        this.organizationRoleName = organizationRoleName;
    }

    public String getOrganizationRoleName() {
        return this.organizationRoleName;
    }

    public CreateWorkspaceRequest withOrganizationRoleName(String organizationRoleName) {
        this.setOrganizationRoleName(organizationRoleName);
        return this;
    }

    public void setPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public CreateWorkspaceRequest withPermissionType(String permissionType) {
        this.setPermissionType(permissionType);
        return this;
    }

    public CreateWorkspaceRequest withPermissionType(PermissionType permissionType) {
        this.permissionType = permissionType.toString();
        return this;
    }

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    public String getStackSetName() {
        return this.stackSetName;
    }

    public CreateWorkspaceRequest withStackSetName(String stackSetName) {
        this.setStackSetName(stackSetName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateWorkspaceRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateWorkspaceRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateWorkspaceRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVpcConfiguration(VpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public VpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public CreateWorkspaceRequest withVpcConfiguration(VpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public List<String> getWorkspaceDataSources() {
        return this.workspaceDataSources;
    }

    public void setWorkspaceDataSources(Collection<String> workspaceDataSources) {
        if (workspaceDataSources == null) {
            this.workspaceDataSources = null;
            return;
        }
        this.workspaceDataSources = new ArrayList<String>(workspaceDataSources);
    }

    public CreateWorkspaceRequest withWorkspaceDataSources(String ... workspaceDataSources) {
        if (this.workspaceDataSources == null) {
            this.setWorkspaceDataSources(new ArrayList<String>(workspaceDataSources.length));
        }
        for (String ele : workspaceDataSources) {
            this.workspaceDataSources.add(ele);
        }
        return this;
    }

    public CreateWorkspaceRequest withWorkspaceDataSources(Collection<String> workspaceDataSources) {
        this.setWorkspaceDataSources(workspaceDataSources);
        return this;
    }

    public CreateWorkspaceRequest withWorkspaceDataSources(DataSourceType ... workspaceDataSources) {
        ArrayList<String> workspaceDataSourcesCopy = new ArrayList<String>(workspaceDataSources.length);
        for (DataSourceType value : workspaceDataSources) {
            workspaceDataSourcesCopy.add(value.toString());
        }
        if (this.getWorkspaceDataSources() == null) {
            this.setWorkspaceDataSources(workspaceDataSourcesCopy);
        } else {
            this.getWorkspaceDataSources().addAll(workspaceDataSourcesCopy);
        }
        return this;
    }

    public void setWorkspaceDescription(String workspaceDescription) {
        this.workspaceDescription = workspaceDescription;
    }

    public String getWorkspaceDescription() {
        return this.workspaceDescription;
    }

    public CreateWorkspaceRequest withWorkspaceDescription(String workspaceDescription) {
        this.setWorkspaceDescription(workspaceDescription);
        return this;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public CreateWorkspaceRequest withWorkspaceName(String workspaceName) {
        this.setWorkspaceName(workspaceName);
        return this;
    }

    public List<String> getWorkspaceNotificationDestinations() {
        return this.workspaceNotificationDestinations;
    }

    public void setWorkspaceNotificationDestinations(Collection<String> workspaceNotificationDestinations) {
        if (workspaceNotificationDestinations == null) {
            this.workspaceNotificationDestinations = null;
            return;
        }
        this.workspaceNotificationDestinations = new ArrayList<String>(workspaceNotificationDestinations);
    }

    public CreateWorkspaceRequest withWorkspaceNotificationDestinations(String ... workspaceNotificationDestinations) {
        if (this.workspaceNotificationDestinations == null) {
            this.setWorkspaceNotificationDestinations(new ArrayList<String>(workspaceNotificationDestinations.length));
        }
        for (String ele : workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations.add(ele);
        }
        return this;
    }

    public CreateWorkspaceRequest withWorkspaceNotificationDestinations(Collection<String> workspaceNotificationDestinations) {
        this.setWorkspaceNotificationDestinations(workspaceNotificationDestinations);
        return this;
    }

    public CreateWorkspaceRequest withWorkspaceNotificationDestinations(NotificationDestinationType ... workspaceNotificationDestinations) {
        ArrayList<String> workspaceNotificationDestinationsCopy = new ArrayList<String>(workspaceNotificationDestinations.length);
        for (NotificationDestinationType value : workspaceNotificationDestinations) {
            workspaceNotificationDestinationsCopy.add(value.toString());
        }
        if (this.getWorkspaceNotificationDestinations() == null) {
            this.setWorkspaceNotificationDestinations(workspaceNotificationDestinationsCopy);
        } else {
            this.getWorkspaceNotificationDestinations().addAll(workspaceNotificationDestinationsCopy);
        }
        return this;
    }

    public List<String> getWorkspaceOrganizationalUnits() {
        return this.workspaceOrganizationalUnits;
    }

    public void setWorkspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
        if (workspaceOrganizationalUnits == null) {
            this.workspaceOrganizationalUnits = null;
            return;
        }
        this.workspaceOrganizationalUnits = new ArrayList<String>(workspaceOrganizationalUnits);
    }

    public CreateWorkspaceRequest withWorkspaceOrganizationalUnits(String ... workspaceOrganizationalUnits) {
        if (this.workspaceOrganizationalUnits == null) {
            this.setWorkspaceOrganizationalUnits(new ArrayList<String>(workspaceOrganizationalUnits.length));
        }
        for (String ele : workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits.add(ele);
        }
        return this;
    }

    public CreateWorkspaceRequest withWorkspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
        this.setWorkspaceOrganizationalUnits(workspaceOrganizationalUnits);
        return this;
    }

    public void setWorkspaceRoleArn(String workspaceRoleArn) {
        this.workspaceRoleArn = workspaceRoleArn;
    }

    public String getWorkspaceRoleArn() {
        return this.workspaceRoleArn;
    }

    public CreateWorkspaceRequest withWorkspaceRoleArn(String workspaceRoleArn) {
        this.setWorkspaceRoleArn(workspaceRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountAccessType() != null) {
            sb.append("AccountAccessType: ").append(this.getAccountAccessType()).append(",");
        }
        if (this.getAuthenticationProviders() != null) {
            sb.append("AuthenticationProviders: ").append(this.getAuthenticationProviders()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getNetworkAccessControl() != null) {
            sb.append("NetworkAccessControl: ").append(this.getNetworkAccessControl()).append(",");
        }
        if (this.getOrganizationRoleName() != null) {
            sb.append("OrganizationRoleName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPermissionType() != null) {
            sb.append("PermissionType: ").append(this.getPermissionType()).append(",");
        }
        if (this.getStackSetName() != null) {
            sb.append("StackSetName: ").append(this.getStackSetName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getWorkspaceDataSources() != null) {
            sb.append("WorkspaceDataSources: ").append(this.getWorkspaceDataSources()).append(",");
        }
        if (this.getWorkspaceDescription() != null) {
            sb.append("WorkspaceDescription: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getWorkspaceName() != null) {
            sb.append("WorkspaceName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getWorkspaceNotificationDestinations() != null) {
            sb.append("WorkspaceNotificationDestinations: ").append(this.getWorkspaceNotificationDestinations()).append(",");
        }
        if (this.getWorkspaceOrganizationalUnits() != null) {
            sb.append("WorkspaceOrganizationalUnits: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getWorkspaceRoleArn() != null) {
            sb.append("WorkspaceRoleArn: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceRequest)) {
            return false;
        }
        CreateWorkspaceRequest other = (CreateWorkspaceRequest)obj;
        if (other.getAccountAccessType() == null ^ this.getAccountAccessType() == null) {
            return false;
        }
        if (other.getAccountAccessType() != null && !other.getAccountAccessType().equals(this.getAccountAccessType())) {
            return false;
        }
        if (other.getAuthenticationProviders() == null ^ this.getAuthenticationProviders() == null) {
            return false;
        }
        if (other.getAuthenticationProviders() != null && !other.getAuthenticationProviders().equals(this.getAuthenticationProviders())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getNetworkAccessControl() == null ^ this.getNetworkAccessControl() == null) {
            return false;
        }
        if (other.getNetworkAccessControl() != null && !other.getNetworkAccessControl().equals(this.getNetworkAccessControl())) {
            return false;
        }
        if (other.getOrganizationRoleName() == null ^ this.getOrganizationRoleName() == null) {
            return false;
        }
        if (other.getOrganizationRoleName() != null && !other.getOrganizationRoleName().equals(this.getOrganizationRoleName())) {
            return false;
        }
        if (other.getPermissionType() == null ^ this.getPermissionType() == null) {
            return false;
        }
        if (other.getPermissionType() != null && !other.getPermissionType().equals(this.getPermissionType())) {
            return false;
        }
        if (other.getStackSetName() == null ^ this.getStackSetName() == null) {
            return false;
        }
        if (other.getStackSetName() != null && !other.getStackSetName().equals(this.getStackSetName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getWorkspaceDataSources() == null ^ this.getWorkspaceDataSources() == null) {
            return false;
        }
        if (other.getWorkspaceDataSources() != null && !other.getWorkspaceDataSources().equals(this.getWorkspaceDataSources())) {
            return false;
        }
        if (other.getWorkspaceDescription() == null ^ this.getWorkspaceDescription() == null) {
            return false;
        }
        if (other.getWorkspaceDescription() != null && !other.getWorkspaceDescription().equals(this.getWorkspaceDescription())) {
            return false;
        }
        if (other.getWorkspaceName() == null ^ this.getWorkspaceName() == null) {
            return false;
        }
        if (other.getWorkspaceName() != null && !other.getWorkspaceName().equals(this.getWorkspaceName())) {
            return false;
        }
        if (other.getWorkspaceNotificationDestinations() == null ^ this.getWorkspaceNotificationDestinations() == null) {
            return false;
        }
        if (other.getWorkspaceNotificationDestinations() != null && !other.getWorkspaceNotificationDestinations().equals(this.getWorkspaceNotificationDestinations())) {
            return false;
        }
        if (other.getWorkspaceOrganizationalUnits() == null ^ this.getWorkspaceOrganizationalUnits() == null) {
            return false;
        }
        if (other.getWorkspaceOrganizationalUnits() != null && !other.getWorkspaceOrganizationalUnits().equals(this.getWorkspaceOrganizationalUnits())) {
            return false;
        }
        if (other.getWorkspaceRoleArn() == null ^ this.getWorkspaceRoleArn() == null) {
            return false;
        }
        return other.getWorkspaceRoleArn() == null || other.getWorkspaceRoleArn().equals(this.getWorkspaceRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountAccessType() == null ? 0 : this.getAccountAccessType().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationProviders() == null ? 0 : this.getAuthenticationProviders().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkAccessControl() == null ? 0 : this.getNetworkAccessControl().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationRoleName() == null ? 0 : this.getOrganizationRoleName().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionType() == null ? 0 : this.getPermissionType().hashCode());
        hashCode = 31 * hashCode + (this.getStackSetName() == null ? 0 : this.getStackSetName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceDataSources() == null ? 0 : this.getWorkspaceDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceDescription() == null ? 0 : this.getWorkspaceDescription().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceName() == null ? 0 : this.getWorkspaceName().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceNotificationDestinations() == null ? 0 : this.getWorkspaceNotificationDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceOrganizationalUnits() == null ? 0 : this.getWorkspaceOrganizationalUnits().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceRoleArn() == null ? 0 : this.getWorkspaceRoleArn().hashCode());
        return hashCode;
    }

    public CreateWorkspaceRequest clone() {
        return (CreateWorkspaceRequest)super.clone();
    }
}

