/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.managedgrafana.model.AuthenticationProviderTypes;
import com.amazonaws.services.managedgrafana.model.SamlConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateWorkspaceAuthenticationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> authenticationProviders;
    private SamlConfiguration samlConfiguration;
    private String workspaceId;

    public List<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public void setAuthenticationProviders(Collection<String> authenticationProviders) {
        if (authenticationProviders == null) {
            this.authenticationProviders = null;
            return;
        }
        this.authenticationProviders = new ArrayList<String>(authenticationProviders);
    }

    public UpdateWorkspaceAuthenticationRequest withAuthenticationProviders(String ... authenticationProviders) {
        if (this.authenticationProviders == null) {
            this.setAuthenticationProviders(new ArrayList<String>(authenticationProviders.length));
        }
        for (String ele : authenticationProviders) {
            this.authenticationProviders.add(ele);
        }
        return this;
    }

    public UpdateWorkspaceAuthenticationRequest withAuthenticationProviders(Collection<String> authenticationProviders) {
        this.setAuthenticationProviders(authenticationProviders);
        return this;
    }

    public UpdateWorkspaceAuthenticationRequest withAuthenticationProviders(AuthenticationProviderTypes ... authenticationProviders) {
        ArrayList<String> authenticationProvidersCopy = new ArrayList<String>(authenticationProviders.length);
        for (AuthenticationProviderTypes value : authenticationProviders) {
            authenticationProvidersCopy.add(value.toString());
        }
        if (this.getAuthenticationProviders() == null) {
            this.setAuthenticationProviders(authenticationProvidersCopy);
        } else {
            this.getAuthenticationProviders().addAll(authenticationProvidersCopy);
        }
        return this;
    }

    public void setSamlConfiguration(SamlConfiguration samlConfiguration) {
        this.samlConfiguration = samlConfiguration;
    }

    public SamlConfiguration getSamlConfiguration() {
        return this.samlConfiguration;
    }

    public UpdateWorkspaceAuthenticationRequest withSamlConfiguration(SamlConfiguration samlConfiguration) {
        this.setSamlConfiguration(samlConfiguration);
        return this;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public UpdateWorkspaceAuthenticationRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthenticationProviders() != null) {
            sb.append("AuthenticationProviders: ").append(this.getAuthenticationProviders()).append(",");
        }
        if (this.getSamlConfiguration() != null) {
            sb.append("SamlConfiguration: ").append(this.getSamlConfiguration()).append(",");
        }
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceAuthenticationRequest)) {
            return false;
        }
        UpdateWorkspaceAuthenticationRequest other = (UpdateWorkspaceAuthenticationRequest)obj;
        if (other.getAuthenticationProviders() == null ^ this.getAuthenticationProviders() == null) {
            return false;
        }
        if (other.getAuthenticationProviders() != null && !other.getAuthenticationProviders().equals(this.getAuthenticationProviders())) {
            return false;
        }
        if (other.getSamlConfiguration() == null ^ this.getSamlConfiguration() == null) {
            return false;
        }
        if (other.getSamlConfiguration() != null && !other.getSamlConfiguration().equals(this.getSamlConfiguration())) {
            return false;
        }
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        return other.getWorkspaceId() == null || other.getWorkspaceId().equals(this.getWorkspaceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthenticationProviders() == null ? 0 : this.getAuthenticationProviders().hashCode());
        hashCode = 31 * hashCode + (this.getSamlConfiguration() == null ? 0 : this.getSamlConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        return hashCode;
    }

    public UpdateWorkspaceAuthenticationRequest clone() {
        return (UpdateWorkspaceAuthenticationRequest)super.clone();
    }
}

