/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.managedgrafana.AmazonManagedGrafanaAsync;
import com.amazonaws.services.managedgrafana.AmazonManagedGrafanaAsyncClientBuilder;
import com.amazonaws.services.managedgrafana.AmazonManagedGrafanaClient;
import com.amazonaws.services.managedgrafana.model.AssociateLicenseRequest;
import com.amazonaws.services.managedgrafana.model.AssociateLicenseResult;
import com.amazonaws.services.managedgrafana.model.CreateWorkspaceRequest;
import com.amazonaws.services.managedgrafana.model.CreateWorkspaceResult;
import com.amazonaws.services.managedgrafana.model.DeleteWorkspaceRequest;
import com.amazonaws.services.managedgrafana.model.DeleteWorkspaceResult;
import com.amazonaws.services.managedgrafana.model.DescribeWorkspaceAuthenticationRequest;
import com.amazonaws.services.managedgrafana.model.DescribeWorkspaceAuthenticationResult;
import com.amazonaws.services.managedgrafana.model.DescribeWorkspaceRequest;
import com.amazonaws.services.managedgrafana.model.DescribeWorkspaceResult;
import com.amazonaws.services.managedgrafana.model.DisassociateLicenseRequest;
import com.amazonaws.services.managedgrafana.model.DisassociateLicenseResult;
import com.amazonaws.services.managedgrafana.model.ListPermissionsRequest;
import com.amazonaws.services.managedgrafana.model.ListPermissionsResult;
import com.amazonaws.services.managedgrafana.model.ListTagsForResourceRequest;
import com.amazonaws.services.managedgrafana.model.ListTagsForResourceResult;
import com.amazonaws.services.managedgrafana.model.ListWorkspacesRequest;
import com.amazonaws.services.managedgrafana.model.ListWorkspacesResult;
import com.amazonaws.services.managedgrafana.model.TagResourceRequest;
import com.amazonaws.services.managedgrafana.model.TagResourceResult;
import com.amazonaws.services.managedgrafana.model.UntagResourceRequest;
import com.amazonaws.services.managedgrafana.model.UntagResourceResult;
import com.amazonaws.services.managedgrafana.model.UpdatePermissionsRequest;
import com.amazonaws.services.managedgrafana.model.UpdatePermissionsResult;
import com.amazonaws.services.managedgrafana.model.UpdateWorkspaceAuthenticationRequest;
import com.amazonaws.services.managedgrafana.model.UpdateWorkspaceAuthenticationResult;
import com.amazonaws.services.managedgrafana.model.UpdateWorkspaceRequest;
import com.amazonaws.services.managedgrafana.model.UpdateWorkspaceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonManagedGrafanaAsyncClient
extends AmazonManagedGrafanaClient
implements AmazonManagedGrafanaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonManagedGrafanaAsyncClientBuilder asyncBuilder() {
        return AmazonManagedGrafanaAsyncClientBuilder.standard();
    }

    AmazonManagedGrafanaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonManagedGrafanaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateLicenseResult> associateLicenseAsync(AssociateLicenseRequest request) {
        return this.associateLicenseAsync(request, null);
    }

    @Override
    public Future<AssociateLicenseResult> associateLicenseAsync(AssociateLicenseRequest request, final AsyncHandler<AssociateLicenseRequest, AssociateLicenseResult> asyncHandler) {
        final AssociateLicenseRequest finalRequest = (AssociateLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateLicenseResult>(){

            @Override
            public AssociateLicenseResult call() throws Exception {
                AssociateLicenseResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeAssociateLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkspaceResult> createWorkspaceAsync(CreateWorkspaceRequest request) {
        return this.createWorkspaceAsync(request, null);
    }

    @Override
    public Future<CreateWorkspaceResult> createWorkspaceAsync(CreateWorkspaceRequest request, final AsyncHandler<CreateWorkspaceRequest, CreateWorkspaceResult> asyncHandler) {
        final CreateWorkspaceRequest finalRequest = (CreateWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkspaceResult>(){

            @Override
            public CreateWorkspaceResult call() throws Exception {
                CreateWorkspaceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeCreateWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkspaceResult> deleteWorkspaceAsync(DeleteWorkspaceRequest request) {
        return this.deleteWorkspaceAsync(request, null);
    }

    @Override
    public Future<DeleteWorkspaceResult> deleteWorkspaceAsync(DeleteWorkspaceRequest request, final AsyncHandler<DeleteWorkspaceRequest, DeleteWorkspaceResult> asyncHandler) {
        final DeleteWorkspaceRequest finalRequest = (DeleteWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkspaceResult>(){

            @Override
            public DeleteWorkspaceResult call() throws Exception {
                DeleteWorkspaceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeDeleteWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceResult> describeWorkspaceAsync(DescribeWorkspaceRequest request) {
        return this.describeWorkspaceAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceResult> describeWorkspaceAsync(DescribeWorkspaceRequest request, final AsyncHandler<DescribeWorkspaceRequest, DescribeWorkspaceResult> asyncHandler) {
        final DescribeWorkspaceRequest finalRequest = (DescribeWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspaceResult>(){

            @Override
            public DescribeWorkspaceResult call() throws Exception {
                DescribeWorkspaceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeDescribeWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceAuthenticationResult> describeWorkspaceAuthenticationAsync(DescribeWorkspaceAuthenticationRequest request) {
        return this.describeWorkspaceAuthenticationAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceAuthenticationResult> describeWorkspaceAuthenticationAsync(DescribeWorkspaceAuthenticationRequest request, final AsyncHandler<DescribeWorkspaceAuthenticationRequest, DescribeWorkspaceAuthenticationResult> asyncHandler) {
        final DescribeWorkspaceAuthenticationRequest finalRequest = (DescribeWorkspaceAuthenticationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspaceAuthenticationResult>(){

            @Override
            public DescribeWorkspaceAuthenticationResult call() throws Exception {
                DescribeWorkspaceAuthenticationResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeDescribeWorkspaceAuthentication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateLicenseResult> disassociateLicenseAsync(DisassociateLicenseRequest request) {
        return this.disassociateLicenseAsync(request, null);
    }

    @Override
    public Future<DisassociateLicenseResult> disassociateLicenseAsync(DisassociateLicenseRequest request, final AsyncHandler<DisassociateLicenseRequest, DisassociateLicenseResult> asyncHandler) {
        final DisassociateLicenseRequest finalRequest = (DisassociateLicenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateLicenseResult>(){

            @Override
            public DisassociateLicenseResult call() throws Exception {
                DisassociateLicenseResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeDisassociateLicense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request) {
        return this.listPermissionsAsync(request, null);
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request, final AsyncHandler<ListPermissionsRequest, ListPermissionsResult> asyncHandler) {
        final ListPermissionsRequest finalRequest = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionsResult>(){

            @Override
            public ListPermissionsResult call() throws Exception {
                ListPermissionsResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeListPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkspacesResult> listWorkspacesAsync(ListWorkspacesRequest request) {
        return this.listWorkspacesAsync(request, null);
    }

    @Override
    public Future<ListWorkspacesResult> listWorkspacesAsync(ListWorkspacesRequest request, final AsyncHandler<ListWorkspacesRequest, ListWorkspacesResult> asyncHandler) {
        final ListWorkspacesRequest finalRequest = (ListWorkspacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkspacesResult>(){

            @Override
            public ListWorkspacesResult call() throws Exception {
                ListWorkspacesResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeListWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePermissionsResult> updatePermissionsAsync(UpdatePermissionsRequest request) {
        return this.updatePermissionsAsync(request, null);
    }

    @Override
    public Future<UpdatePermissionsResult> updatePermissionsAsync(UpdatePermissionsRequest request, final AsyncHandler<UpdatePermissionsRequest, UpdatePermissionsResult> asyncHandler) {
        final UpdatePermissionsRequest finalRequest = (UpdatePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePermissionsResult>(){

            @Override
            public UpdatePermissionsResult call() throws Exception {
                UpdatePermissionsResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeUpdatePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkspaceResult> updateWorkspaceAsync(UpdateWorkspaceRequest request) {
        return this.updateWorkspaceAsync(request, null);
    }

    @Override
    public Future<UpdateWorkspaceResult> updateWorkspaceAsync(UpdateWorkspaceRequest request, final AsyncHandler<UpdateWorkspaceRequest, UpdateWorkspaceResult> asyncHandler) {
        final UpdateWorkspaceRequest finalRequest = (UpdateWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkspaceResult>(){

            @Override
            public UpdateWorkspaceResult call() throws Exception {
                UpdateWorkspaceResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeUpdateWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkspaceAuthenticationResult> updateWorkspaceAuthenticationAsync(UpdateWorkspaceAuthenticationRequest request) {
        return this.updateWorkspaceAuthenticationAsync(request, null);
    }

    @Override
    public Future<UpdateWorkspaceAuthenticationResult> updateWorkspaceAuthenticationAsync(UpdateWorkspaceAuthenticationRequest request, final AsyncHandler<UpdateWorkspaceAuthenticationRequest, UpdateWorkspaceAuthenticationResult> asyncHandler) {
        final UpdateWorkspaceAuthenticationRequest finalRequest = (UpdateWorkspaceAuthenticationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkspaceAuthenticationResult>(){

            @Override
            public UpdateWorkspaceAuthenticationResult call() throws Exception {
                UpdateWorkspaceAuthenticationResult result = null;
                try {
                    result = AmazonManagedGrafanaAsyncClient.this.executeUpdateWorkspaceAuthentication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

