/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchainquery.model.QueryNetwork;
import com.amazonaws.services.managedblockchainquery.model.QueryTokenStandard;
import com.amazonaws.services.managedblockchainquery.model.transform.ContractFilterMarshaller;
import java.io.Serializable;

public class ContractFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String network;
    private String tokenStandard;
    private String deployerAddress;

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getNetwork() {
        return this.network;
    }

    public ContractFilter withNetwork(String network) {
        this.setNetwork(network);
        return this;
    }

    public ContractFilter withNetwork(QueryNetwork network) {
        this.network = network.toString();
        return this;
    }

    public void setTokenStandard(String tokenStandard) {
        this.tokenStandard = tokenStandard;
    }

    public String getTokenStandard() {
        return this.tokenStandard;
    }

    public ContractFilter withTokenStandard(String tokenStandard) {
        this.setTokenStandard(tokenStandard);
        return this;
    }

    public ContractFilter withTokenStandard(QueryTokenStandard tokenStandard) {
        this.tokenStandard = tokenStandard.toString();
        return this;
    }

    public void setDeployerAddress(String deployerAddress) {
        this.deployerAddress = deployerAddress;
    }

    public String getDeployerAddress() {
        return this.deployerAddress;
    }

    public ContractFilter withDeployerAddress(String deployerAddress) {
        this.setDeployerAddress(deployerAddress);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetwork() != null) {
            sb.append("Network: ").append(this.getNetwork()).append(",");
        }
        if (this.getTokenStandard() != null) {
            sb.append("TokenStandard: ").append(this.getTokenStandard()).append(",");
        }
        if (this.getDeployerAddress() != null) {
            sb.append("DeployerAddress: ").append(this.getDeployerAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContractFilter)) {
            return false;
        }
        ContractFilter other = (ContractFilter)obj;
        if (other.getNetwork() == null ^ this.getNetwork() == null) {
            return false;
        }
        if (other.getNetwork() != null && !other.getNetwork().equals(this.getNetwork())) {
            return false;
        }
        if (other.getTokenStandard() == null ^ this.getTokenStandard() == null) {
            return false;
        }
        if (other.getTokenStandard() != null && !other.getTokenStandard().equals(this.getTokenStandard())) {
            return false;
        }
        if (other.getDeployerAddress() == null ^ this.getDeployerAddress() == null) {
            return false;
        }
        return other.getDeployerAddress() == null || other.getDeployerAddress().equals(this.getDeployerAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetwork() == null ? 0 : this.getNetwork().hashCode());
        hashCode = 31 * hashCode + (this.getTokenStandard() == null ? 0 : this.getTokenStandard().hashCode());
        hashCode = 31 * hashCode + (this.getDeployerAddress() == null ? 0 : this.getDeployerAddress().hashCode());
        return hashCode;
    }

    public ContractFilter clone() {
        try {
            return (ContractFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContractFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

