/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.managedblockchain.model.NetworkSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListNetworksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<NetworkSummary> networks;
    private String nextToken;

    public List<NetworkSummary> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Collection<NetworkSummary> networks) {
        if (networks == null) {
            this.networks = null;
            return;
        }
        this.networks = new ArrayList<NetworkSummary>(networks);
    }

    public ListNetworksResult withNetworks(NetworkSummary ... networks) {
        if (this.networks == null) {
            this.setNetworks(new ArrayList<NetworkSummary>(networks.length));
        }
        for (NetworkSummary ele : networks) {
            this.networks.add(ele);
        }
        return this;
    }

    public ListNetworksResult withNetworks(Collection<NetworkSummary> networks) {
        this.setNetworks(networks);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListNetworksResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworks() != null) {
            sb.append("Networks: ").append(this.getNetworks()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworksResult)) {
            return false;
        }
        ListNetworksResult other = (ListNetworksResult)obj;
        if (other.getNetworks() == null ^ this.getNetworks() == null) {
            return false;
        }
        if (other.getNetworks() != null && !other.getNetworks().equals(this.getNetworks())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworks() == null ? 0 : this.getNetworks().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListNetworksResult clone() {
        try {
            return (ListNetworksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

