/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mailmanager.model.RuleAction;
import com.amazonaws.services.mailmanager.model.RuleCondition;
import com.amazonaws.services.mailmanager.model.transform.RuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Rule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<RuleAction> actions;
    private List<RuleCondition> conditions;
    private String name;
    private List<RuleCondition> unless;

    public List<RuleAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<RuleAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<RuleAction>(actions);
    }

    public Rule withActions(RuleAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<RuleAction>(actions.length));
        }
        for (RuleAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public Rule withActions(Collection<RuleAction> actions) {
        this.setActions(actions);
        return this;
    }

    public List<RuleCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<RuleCondition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<RuleCondition>(conditions);
    }

    public Rule withConditions(RuleCondition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<RuleCondition>(conditions.length));
        }
        for (RuleCondition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public Rule withConditions(Collection<RuleCondition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rule withName(String name) {
        this.setName(name);
        return this;
    }

    public List<RuleCondition> getUnless() {
        return this.unless;
    }

    public void setUnless(Collection<RuleCondition> unless) {
        if (unless == null) {
            this.unless = null;
            return;
        }
        this.unless = new ArrayList<RuleCondition>(unless);
    }

    public Rule withUnless(RuleCondition ... unless) {
        if (this.unless == null) {
            this.setUnless(new ArrayList<RuleCondition>(unless.length));
        }
        for (RuleCondition ele : unless) {
            this.unless.add(ele);
        }
        return this;
    }

    public Rule withUnless(Collection<RuleCondition> unless) {
        this.setUnless(unless);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getUnless() != null) {
            sb.append("Unless: ").append(this.getUnless());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        if (other.getConditions() != null && !other.getConditions().equals(this.getConditions())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getUnless() == null ^ this.getUnless() == null) {
            return false;
        }
        return other.getUnless() == null || other.getUnless().equals(this.getUnless());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getUnless() == null ? 0 : this.getUnless().hashCode());
        return hashCode;
    }

    public Rule clone() {
        try {
            return (Rule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

