/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mailmanager.model.AcceptAction;
import com.amazonaws.services.mailmanager.model.PolicyCondition;
import com.amazonaws.services.mailmanager.model.transform.PolicyStatementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private String action;
    private List<PolicyCondition> conditions;

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public PolicyStatement withAction(String action) {
        this.setAction(action);
        return this;
    }

    public PolicyStatement withAction(AcceptAction action) {
        this.action = action.toString();
        return this;
    }

    public List<PolicyCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<PolicyCondition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<PolicyCondition>(conditions);
    }

    public PolicyStatement withConditions(PolicyCondition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<PolicyCondition>(conditions.length));
        }
        for (PolicyCondition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public PolicyStatement withConditions(Collection<PolicyCondition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyStatement)) {
            return false;
        }
        PolicyStatement other = (PolicyStatement)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        return other.getConditions() == null || other.getConditions().equals(this.getConditions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        return hashCode;
    }

    public PolicyStatement clone() {
        try {
            return (PolicyStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

